/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.wildfly.clustering.web.cache.session.FilteringHttpSession;
import org.wildfly.clustering.web.cache.session.ImmutableFilteringHttpSession;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionAttributeActivationNotifier
implements SessionAttributeActivationNotifier {
    private static final Function<Supplier<HttpSessionActivationListener>, HttpSessionActivationListener> PRE_PASSIVATE_LISTENER_FACTORY = new HttpSessionActivationListenerFactory(true);
    private static final Function<Supplier<HttpSessionActivationListener>, HttpSessionActivationListener> POST_ACTIVATE_LISTENER_FACTORY = new HttpSessionActivationListenerFactory(false);
    private final HttpSessionEvent event;
    private final Map<Supplier<HttpSessionActivationListener>, HttpSessionActivationListener> listeners = new ConcurrentHashMap<Supplier<HttpSessionActivationListener>, HttpSessionActivationListener>();

    public ImmutableSessionAttributeActivationNotifier(ImmutableSession session, ServletContext context) {
        this(new ImmutableFilteringHttpSession(session, context));
    }

    public ImmutableSessionAttributeActivationNotifier(FilteringHttpSession session) {
        this.event = new HttpSessionEvent((HttpSession)session);
    }

    @Override
    public void prePassivate(Object object) {
        if (object instanceof HttpSessionActivationListener) {
            HttpSessionActivationListenerKey reference = new HttpSessionActivationListenerKey((HttpSessionActivationListener)object);
            HttpSessionActivationListener listener = this.listeners.computeIfAbsent(reference, PRE_PASSIVATE_LISTENER_FACTORY);
            listener.sessionWillPassivate(this.event);
        }
    }

    @Override
    public void postActivate(Object object) {
        if (object instanceof HttpSessionActivationListener) {
            HttpSessionActivationListenerKey reference = new HttpSessionActivationListenerKey((HttpSessionActivationListener)object);
            HttpSessionActivationListener listener = this.listeners.computeIfAbsent(reference, POST_ACTIVATE_LISTENER_FACTORY);
            listener.sessionDidActivate(this.event);
        }
    }

    @Override
    public void close() {
        for (HttpSessionActivationListener listener : this.listeners.values()) {
            listener.sessionWillPassivate(this.event);
        }
        this.listeners.clear();
    }

    private static class AtomicHttpSessionActivationListener
    implements HttpSessionActivationListener {
        private final HttpSessionActivationListener listener;
        private final AtomicBoolean active;

        AtomicHttpSessionActivationListener(HttpSessionActivationListener listener, boolean active) {
            this.listener = listener;
            this.active = new AtomicBoolean(active);
        }

        public void sessionWillPassivate(HttpSessionEvent event) {
            if (this.active.compareAndSet(true, false)) {
                this.listener.sessionWillPassivate(event);
            }
        }

        public void sessionDidActivate(HttpSessionEvent event) {
            if (this.active.compareAndSet(false, true)) {
                this.listener.sessionDidActivate(event);
            }
        }
    }

    private static class HttpSessionActivationListenerFactory
    implements Function<Supplier<HttpSessionActivationListener>, HttpSessionActivationListener> {
        private final boolean active;

        HttpSessionActivationListenerFactory(boolean active) {
            this.active = active;
        }

        @Override
        public HttpSessionActivationListener apply(Supplier<HttpSessionActivationListener> reference) {
            return new AtomicHttpSessionActivationListener(reference.get(), this.active);
        }
    }

    private static class HttpSessionActivationListenerKey
    implements Supplier<HttpSessionActivationListener> {
        private final HttpSessionActivationListener listener;

        HttpSessionActivationListenerKey(HttpSessionActivationListener listener) {
            this.listener = listener;
        }

        @Override
        public HttpSessionActivationListener get() {
            return this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HttpSessionActivationListenerKey)) {
                return false;
            }
            HttpSessionActivationListenerKey reference = (HttpSessionActivationListenerKey)object;
            return this.listener == reference.listener;
        }
    }
}

