/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class VoidResponseCollector
extends ValidResponseCollector<Void> {
    private final boolean ignoreLeavers;
    private Exception exception;

    public static VoidResponseCollector validOnly() {
        return new VoidResponseCollector(false);
    }

    public static VoidResponseCollector ignoreLeavers() {
        return new VoidResponseCollector(true);
    }

    private VoidResponseCollector(boolean ignoreLeavers) {
        this.ignoreLeavers = ignoreLeavers;
    }

    @Override
    protected Void addTargetNotFound(Address sender) {
        if (!this.ignoreLeavers) {
            this.recordException((Exception)((Object)ResponseCollectors.remoteNodeSuspected(sender)));
        }
        return null;
    }

    @Override
    protected Void addException(Address sender, Exception exception) {
        this.recordException((Exception)((Object)ResponseCollectors.wrapRemoteException(sender, exception)));
        return null;
    }

    private void recordException(Exception e) {
        if (this.exception == null) {
            this.exception = e;
        } else {
            this.exception.addSuppressed(e);
        }
    }

    @Override
    protected Void addValidResponse(Address sender, ValidResponse response) {
        return null;
    }

    @Override
    public Void finish() {
        if (this.exception != null) {
            throw CompletableFutures.asCompletionException(this.exception);
        }
        return null;
    }
}

