/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MultiTargetRequest<T>
extends AbstractRequest<T> {
    private static final Log log = LogFactory.getLog(MultiTargetRequest.class);
    private static final boolean trace = log.isTraceEnabled();
    @GuardedBy(value="responseCollector")
    private final Address[] targets;
    @GuardedBy(value="responseCollector")
    private int missingResponses;

    public MultiTargetRequest(ResponseCollector<T> responseCollector, long requestId, RequestRepository repository, Collection<Address> targets, Address excluded) {
        super(requestId, responseCollector, repository);
        this.targets = new Address[targets.size()];
        int i = 0;
        for (Address target : targets) {
            if (excluded != null && excluded.equals(target)) continue;
            this.targets[i++] = target;
        }
        this.missingResponses = i;
        if (this.missingResponses == 0) {
            this.complete(responseCollector.finish());
        }
    }

    protected int getTargetsSize() {
        return this.targets.length;
    }

    protected Address getTarget(int i) {
        return this.targets[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Address sender, Response response) {
        try {
            Object result;
            boolean isDone = false;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                if (this.missingResponses <= 0) {
                    return;
                }
                boolean validSender = false;
                for (int i = 0; i < this.targets.length; ++i) {
                    Address target = this.targets[i];
                    if (target == null || !target.equals(sender)) continue;
                    validSender = true;
                    this.targets[i] = null;
                    --this.missingResponses;
                    break;
                }
                if (!validSender) {
                    if (trace) {
                        log.tracef("Ignoring unexpected response to request %d from %s: %s", this.requestId, sender, response);
                    }
                    return;
                }
                result = this.responseCollector.addResponse(sender, response);
                if (result != null) {
                    isDone = true;
                } else if (this.missingResponses <= 0) {
                    isDone = true;
                    result = this.responseCollector.finish();
                }
            }
            if (isDone) {
                this.complete(result);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewView(Set<Address> members) {
        boolean targetRemoved = false;
        try {
            boolean isDone = false;
            Object result = null;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                if (this.missingResponses <= 0) {
                    return false;
                }
                for (int i = 0; i < this.targets.length; ++i) {
                    Address target = this.targets[i];
                    if (target == null || members.contains(target)) continue;
                    this.targets[i] = null;
                    --this.missingResponses;
                    targetRemoved = true;
                    if (trace) {
                        log.tracef("Target %s of request %d left the cluster view", target, this.requestId);
                    }
                    if ((result = (Object)this.responseCollector.addResponse(target, CacheNotFoundResponse.INSTANCE)) == null) continue;
                    isDone = true;
                    break;
                }
                if (!isDone && this.missingResponses <= 0) {
                    result = this.responseCollector.finish();
                    isDone = true;
                }
            }
            if (isDone) {
                this.complete(result);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
        return targetRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onTimeout() {
        ResponseCollector responseCollector = this.responseCollector;
        synchronized (responseCollector) {
            if (this.missingResponses <= 0) {
                return;
            }
            this.missingResponses = 0;
        }
        String targetsWithoutResponses = Arrays.stream(this.targets).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
        this.completeExceptionally((Throwable)((Object)log.requestTimedOut(this.requestId, targetsWithoutResponses)));
    }
}

