/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.util.InvalidEnumerationException;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.soap.envelope.Fault;
import org.xmlsoap.schemas.soap.envelope.ObjectFactory;

public class SoapFault11
extends SoapFault {
    private Element detailElement;
    private Element[] headerElements;
    private static ObjectFactory factory = new ObjectFactory();

    public SoapFault11() {
    }

    public SoapFault11(Throwable th) {
        super(th);
    }

    public SoapFault11(Throwable th, Element[] headerElements) {
        super(th);
        this.headerElements = headerElements;
    }

    public SoapFault11(SoapFaultType soapFaultType, QName subcode, String reason) {
        super(soapFaultType, subcode, reason);
    }

    public SoapFault11(SoapFaultType soapFaultType, QName subcode, String reason, Element[] headerElements) {
        super(soapFaultType, subcode, reason, null);
        this.headerElements = headerElements;
    }

    public SoapFault11(SoapFaultType soapFaultType, QName subcode, String reason, Element detailElement) {
        super(soapFaultType, subcode, reason, SoapFault11.getDetailString(detailElement));
        this.detailElement = detailElement;
    }

    public SoapFault11(SoapFaultType soapFaultType, String reason) {
        this(soapFaultType, null, reason, null, null);
    }

    public SoapFault11(SoapFaultType soapFaultType, String reason, Element detailElement) {
        this(soapFaultType, null, reason, detailElement, null);
    }

    public SoapFault11(SoapFaultType soapFaultType, QName subcode, String reason, Element detailElement, Element[] headerElements) {
        this.soapFaultType = soapFaultType;
        this.subcode = subcode;
        this.reason = reason;
        this.detailElement = detailElement;
        this.headerElements = headerElements;
    }

    public Fault toFault() {
        Fault fault = factory.createFault();
        QName faultcode = this.subcode;
        String faultstring = this.getReason();
        fault.setFaultcode(faultcode);
        fault.setFaultstring(faultstring);
        return fault;
    }

    public static SoapFault11 fromFault(Fault fault) {
        try {
            QName subcode = fault.getFaultcode();
            String reason = fault.getFaultstring();
            return new SoapFault11(SoapFaultType.FAULT_SENDER, subcode, reason);
        }
        catch (Throwable th) {
            return new SoapFault11(th);
        }
    }

    public static SoapFault11 create(SOAPFaultException sfe) {
        try {
            SOAPFault cause = sfe.getFault();
            QName faultCode = cause.getFaultCodeAsQName();
            String reason = cause.getFaultString();
            SoapFaultType soapFaultType = SoapFaultType.toState(reason);
            Detail detail = cause.getDetail();
            return new SoapFault11(soapFaultType, faultCode, null, (Element)detail);
        }
        catch (InvalidEnumerationException e) {
            return new SoapFault11(e);
        }
    }

    public Element getDetailElement() {
        return this.detailElement;
    }

    public void setDetailElement(Element detailElement) {
        this.detailElement = detailElement;
    }

    public Element[] getHeaderElements() {
        return this.headerElements;
    }

    public void setHeaderElements(Element[] headerElements) {
        this.headerElements = headerElements;
    }

    private static String getDetailString(Element detailElement) {
        return detailElement.getTextContent();
    }
}

