/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AbstractKeyManagerService;
import org.jboss.as.domain.management.security.WrapperSSLContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class SSLContextService
implements Service {
    private final Consumer<SSLContext> sslContextConsumer;
    private final Supplier<AbstractKeyManagerService> keyManagersSupplier;
    private final Supplier<TrustManager[]> trustManagersSupplier;
    private volatile String protocol;
    private volatile Set<String> enabledCipherSuites;
    private volatile Set<String> enabledProtocols;
    private volatile SSLContext theSSLContext;

    SSLContextService(Consumer<SSLContext> sslContextConsumer, Supplier<AbstractKeyManagerService> keyManagersSupplier, Supplier<TrustManager[]> trustManagersSupplier, String protocol, Set<String> enabledCipherSuites, Set<String> enabledProtocols) {
        this.sslContextConsumer = sslContextConsumer;
        this.keyManagersSupplier = keyManagersSupplier;
        this.trustManagersSupplier = trustManagersSupplier;
        this.protocol = protocol;
        this.enabledCipherSuites = enabledCipherSuites;
        this.enabledProtocols = enabledProtocols;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void start(StartContext context) throws StartException {
        AbstractKeyManagerService keyManagers = this.keyManagersSupplier != null ? this.keyManagersSupplier.get() : null;
        TrustManager[] trustManagers = this.trustManagersSupplier != null ? this.trustManagersSupplier.get() : null;
        try {
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            if (keyManagers != null && keyManagers.isLazy()) {
                sslContext = new LazyInitSSLContext(sslContext, this.keyManagersSupplier, this.trustManagersSupplier, this.enabledCipherSuites, this.enabledProtocols);
            } else {
                sslContext.init(keyManagers != null ? keyManagers.getKeyManagers() : null, trustManagers, null);
                sslContext = SSLContextService.wrapSslContext(sslContext, this.enabledCipherSuites, this.enabledProtocols);
            }
            this.theSSLContext = sslContext;
            this.sslContextConsumer.accept(this.theSSLContext);
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (KeyManagementException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
    }

    protected static SSLContext wrapSslContext(SSLContext sslContext, Set<String> enabledCipherSuites, Set<String> enabledProtocols) throws StartException {
        if (!enabledCipherSuites.isEmpty() || !enabledProtocols.isEmpty()) {
            String[] commonProtocols;
            String[] commonCiphers;
            SSLParameters parameters = sslContext.getSupportedSSLParameters();
            if (enabledCipherSuites.isEmpty()) {
                commonCiphers = new String[]{};
            } else {
                commonCiphers = SSLContextService.calculateCommon(parameters.getCipherSuites(), enabledCipherSuites);
                if (commonCiphers.length == 0) {
                    throw DomainManagementLogger.ROOT_LOGGER.noCipherSuitesInCommon(Arrays.asList(parameters.getCipherSuites()).toString(), enabledCipherSuites.toString());
                }
            }
            if (enabledProtocols.isEmpty()) {
                commonProtocols = new String[]{};
            } else {
                commonProtocols = SSLContextService.calculateCommon(parameters.getProtocols(), enabledProtocols);
                if (commonProtocols.length == 0) {
                    throw DomainManagementLogger.ROOT_LOGGER.noProtocolsInCommon(Arrays.asList(parameters.getProtocols()).toString(), enabledProtocols.toString());
                }
            }
            sslContext = new WrapperSSLContext(sslContext, commonCiphers, commonProtocols);
        }
        return sslContext;
    }

    private static String[] calculateCommon(String[] supported, Set<String> configured) {
        ArrayList<String> matched = new ArrayList<String>();
        for (String current : supported) {
            if (!configured.contains(current)) continue;
            matched.add(current);
        }
        return matched.toArray(new String[matched.size()]);
    }

    public void stop(StopContext context) {
        this.sslContextConsumer.accept(null);
        this.theSSLContext = null;
    }

    static final class LazyInitSSLContext
    extends SSLContext {
        LazyInitSSLContext(SSLContext toWrap, Supplier<AbstractKeyManagerService> keyManagersSupplier, Supplier<TrustManager[]> trustManagersSupplier, Set<String> enabledCipherSuites, Set<String> enabledProtocols) {
            super(new LazyInitSpi(toWrap, keyManagersSupplier, trustManagersSupplier, enabledCipherSuites, enabledProtocols), toWrap.getProvider(), toWrap.getProtocol());
        }

        private static class LazyInitSpi
        extends SSLContextSpi {
            private volatile SSLContext wrapped;
            private volatile boolean init = false;
            private volatile SSLServerSocketFactory serverSocketFactory;
            private volatile SSLSocketFactory socketFactory;
            final Supplier<AbstractKeyManagerService> keyManagersSupplier;
            final Supplier<TrustManager[]> trustManagersSupplier;
            private final Set<String> enabledCipherSuites;
            private final Set<String> enabledProtocols;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doInit() {
                if (!this.init) {
                    LazyInitSpi lazyInitSpi = this;
                    synchronized (lazyInitSpi) {
                        if (!this.init) {
                            try {
                                AbstractKeyManagerService keyManagers = this.keyManagersSupplier != null ? this.keyManagersSupplier.get() : null;
                                TrustManager[] trustManagers = this.trustManagersSupplier != null ? this.trustManagersSupplier.get() : null;
                                this.wrapped.init(keyManagers.getKeyManagers(), trustManagers, null);
                                this.wrapped = SSLContextService.wrapSslContext(this.wrapped, this.enabledCipherSuites, this.enabledProtocols);
                            }
                            catch (Exception e) {
                                throw DomainManagementLogger.SECURITY_LOGGER.failedToCreateLazyInitSSLContext(e);
                            }
                            finally {
                                this.init = true;
                            }
                        }
                    }
                }
            }

            private LazyInitSpi(SSLContext wrapped, Supplier<AbstractKeyManagerService> keyManagersSupplier, Supplier<TrustManager[]> trustManagersSupplier, Set<String> enabledCipherSuites, Set<String> enabledProtocols) {
                this.wrapped = wrapped;
                this.keyManagersSupplier = keyManagersSupplier;
                this.trustManagersSupplier = trustManagersSupplier;
                this.enabledCipherSuites = enabledCipherSuites;
                this.enabledProtocols = enabledProtocols;
            }

            @Override
            protected SSLEngine engineCreateSSLEngine() {
                this.doInit();
                return this.wrapped.createSSLEngine();
            }

            @Override
            protected SSLEngine engineCreateSSLEngine(String host, int port) {
                this.doInit();
                return this.wrapped.createSSLEngine(host, port);
            }

            @Override
            protected SSLSessionContext engineGetClientSessionContext() {
                return this.wrapped.getClientSessionContext();
            }

            @Override
            protected SSLSessionContext engineGetServerSessionContext() {
                return this.wrapped.getServerSessionContext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected SSLServerSocketFactory engineGetServerSocketFactory() {
                if (this.serverSocketFactory == null) {
                    LazyInitSpi lazyInitSpi = this;
                    synchronized (lazyInitSpi) {
                        if (this.serverSocketFactory == null) {
                            this.serverSocketFactory = new LazySSLServerSocketFactory(this);
                        }
                    }
                }
                return this.serverSocketFactory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected SSLSocketFactory engineGetSocketFactory() {
                if (this.socketFactory == null) {
                    LazyInitSpi lazyInitSpi = this;
                    synchronized (lazyInitSpi) {
                        if (this.socketFactory == null) {
                            this.socketFactory = new LazySSLSocketFactory(this);
                        }
                    }
                }
                return this.socketFactory;
            }

            @Override
            protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
                this.wrapped.init(km, tm, sr);
            }

            private class LazySSLServerSocketFactory
            extends SSLServerSocketFactory {
                private final LazyInitSpi wrapped;
                private volatile SSLServerSocketFactory factory;

                private LazySSLServerSocketFactory(LazyInitSpi wrapped) {
                    this.wrapped = wrapped;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void createFactory() {
                    if (this.factory == null) {
                        LazySSLServerSocketFactory lazySSLServerSocketFactory = this;
                        synchronized (lazySSLServerSocketFactory) {
                            if (this.factory == null) {
                                this.wrapped.doInit();
                                this.factory = this.wrapped.wrapped.getServerSocketFactory();
                            }
                        }
                    }
                }

                @Override
                public String[] getDefaultCipherSuites() {
                    if (this.factory == null) {
                        return this.wrapped.wrapped.getDefaultSSLParameters().getCipherSuites();
                    }
                    return this.factory.getDefaultCipherSuites();
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    if (this.factory == null) {
                        return this.wrapped.wrapped.getSupportedSSLParameters().getCipherSuites();
                    }
                    return this.factory.getSupportedCipherSuites();
                }

                @Override
                public ServerSocket createServerSocket(int port) throws IOException {
                    LazyInitSpi.this.doInit();
                    return this.factory.createServerSocket(port);
                }

                @Override
                public ServerSocket createServerSocket(int port, int backlog) throws IOException {
                    LazyInitSpi.this.doInit();
                    return this.factory.createServerSocket(port, backlog);
                }

                @Override
                public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
                    LazyInitSpi.this.doInit();
                    return this.factory.createServerSocket(port, backlog, ifAddress);
                }
            }

            private class LazySSLSocketFactory
            extends SSLSocketFactory {
                private final LazyInitSpi wrapped;
                private volatile SSLSocketFactory factory;

                private LazySSLSocketFactory(LazyInitSpi wrapped) {
                    this.wrapped = wrapped;
                }

                @Override
                public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                    this.createFactory();
                    return this.factory.createSocket(s, host, port, autoClose);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void createFactory() {
                    if (this.factory == null) {
                        LazySSLSocketFactory lazySSLSocketFactory = this;
                        synchronized (lazySSLSocketFactory) {
                            if (this.factory == null) {
                                this.wrapped.doInit();
                                this.factory = this.wrapped.wrapped.getSocketFactory();
                            }
                        }
                    }
                }

                @Override
                public String[] getDefaultCipherSuites() {
                    if (this.factory == null) {
                        return this.wrapped.wrapped.getDefaultSSLParameters().getCipherSuites();
                    }
                    return this.factory.getDefaultCipherSuites();
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    if (this.factory == null) {
                        return this.wrapped.wrapped.getSupportedSSLParameters().getCipherSuites();
                    }
                    return this.factory.getSupportedCipherSuites();
                }

                @Override
                public Socket createSocket(String host, int port) throws IOException {
                    this.createFactory();
                    return this.factory.createSocket(host, port);
                }

                @Override
                public Socket createSocket(InetAddress host, int port) throws IOException {
                    this.createFactory();
                    return this.factory.createSocket(host, port);
                }

                @Override
                public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
                    this.createFactory();
                    return this.factory.createSocket(host, port, localHost, localPort);
                }

                @Override
                public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                    this.createFactory();
                    return this.factory.createSocket(address, port, localAddress, localPort);
                }

                @Override
                public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
                    this.createFactory();
                    return this.factory.createSocket(s, consumed, autoClose);
                }

                @Override
                public Socket createSocket() throws IOException {
                    this.createFactory();
                    return this.factory.createSocket();
                }
            }
        }
    }

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ssl-context";
        private static final String TRUST_ONLY_SERVICE_SUFFIX = "ssl-context-trust-only";

        public static ServiceName createServiceName(ServiceName parentService, boolean trustOnly) {
            return parentService.append(new String[]{trustOnly ? TRUST_ONLY_SERVICE_SUFFIX : SERVICE_SUFFIX});
        }

        public static Supplier<SSLContext> requires(ServiceBuilder<?> sb, ServiceName parentService, boolean trustOnly) {
            return sb.requires(ServiceUtil.createServiceName(parentService, trustOnly));
        }
    }
}

