/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.lru;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.security.lru.ConcurrentDirectDeque;
import org.jboss.as.security.lru.RemoveCallback;

public class LRUCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private static final int SAMPLE_INTERVAL = 5;
    private final int maxEntries;
    private final ConcurrentHashMap<K, CacheEntry<K, V>> cache = new ConcurrentHashMap();
    private final ConcurrentDirectDeque<CacheEntry<K, V>> accessQueue = ConcurrentDirectDeque.newInstance();
    private final RemoveCallback<K, V> removeCallback;

    public LRUCache(int maxEntries) {
        this(maxEntries, null);
    }

    public LRUCache(int maxEntries, RemoveCallback<K, V> removeCallback) {
        this.maxEntries = maxEntries;
        this.removeCallback = removeCallback;
    }

    @Override
    public V put(K key, V newValue) {
        return this.put(key, newValue, false);
    }

    public V put(K key, V newValue, boolean ifAbsent) {
        CacheEntry oldest;
        CacheEntry<K, V> entry = this.cache.get(key);
        V old = null;
        if (entry == null) {
            entry = new CacheEntry(key, newValue);
            CacheEntry<K, V> result = this.cache.putIfAbsent(key, entry);
            if (result != null) {
                return this.put(key, newValue);
            }
            this.bumpAccess(entry);
        } else {
            old = entry.getValue();
            if (ifAbsent) {
                return old;
            }
            entry.setValue(newValue);
            if (entry.hit() % 5 == 0) {
                this.bumpAccess(entry);
            }
        }
        if (this.cache.size() > this.maxEntries && (oldest = (CacheEntry)this.accessQueue.poll()) != entry) {
            this.remove(oldest.key());
        }
        return old;
    }

    @Override
    public V replace(K key, V newValue) {
        CacheEntry<K, V> cacheEntry = this.get0(key);
        if (cacheEntry == null) {
            return null;
        }
        this.bumpAccess(cacheEntry);
        V old = cacheEntry.getValue();
        cacheEntry.setValue(newValue);
        if (this.removeCallback != null) {
            this.removeCallback.afterRemove(key, old);
        }
        return old;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        CacheEntry<K, V> cacheEntry = this.get0(key);
        if (cacheEntry == null || cacheEntry.getValue() != oldValue) {
            return false;
        }
        boolean ret = cacheEntry.setValue(oldValue, newValue);
        if (ret) {
            this.bumpAccess(cacheEntry);
        }
        if (this.removeCallback != null) {
            this.removeCallback.afterRemove(key, oldValue);
        }
        return ret;
    }

    @Override
    public V get(Object key) {
        CacheEntry<K, V> cacheEntry = this.get0(key);
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry.getValue();
    }

    private CacheEntry<K, V> get0(Object key) {
        CacheEntry<K, V> cacheEntry = this.cache.get(key);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.hit() % 5 == 0) {
            this.bumpAccess(cacheEntry);
        }
        return cacheEntry;
    }

    private void bumpAccess(CacheEntry<K, V> cacheEntry) {
        Object prevToken = cacheEntry.claimToken();
        if (prevToken == Boolean.FALSE) {
            return;
        }
        if (prevToken != null) {
            this.accessQueue.removeToken(prevToken);
        }
        Object token = null;
        try {
            token = this.accessQueue.offerLastAndReturnToken(cacheEntry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!cacheEntry.setToken(token) && token != null) {
            this.accessQueue.removeToken(token);
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        CacheEntry<K, V> toRemove = this.cache.get(key);
        if (toRemove == null || toRemove.getValue() != value || !this.cache.remove(key, toRemove)) {
            return false;
        }
        Object old = toRemove.killToken();
        if (old != null) {
            this.accessQueue.removeToken(old);
        }
        return true;
    }

    @Override
    public V remove(Object key) {
        CacheEntry<K, V> remove = this.cache.remove(key);
        if (remove == null) {
            return null;
        }
        Object old = remove.killToken();
        if (old != null) {
            this.accessQueue.removeToken(old);
        }
        if (this.removeCallback != null) {
            this.removeCallback.afterRemove(remove.key(), remove.getValue());
        }
        return remove.getValue();
    }

    @Override
    public void clear() {
        if (this.removeCallback == null) {
            this.cache.clear();
            this.accessQueue.clear();
        } else {
            Iterator<Map.Entry<K, V>> iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new WrappedEntrySet(this.cache.entrySet());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    private class WrappedIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, CacheEntry<K, V>>> iterator;
        private CacheEntry<K, V> last;

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            final Map.Entry next = this.iterator.next();
            this.last = next.getValue();
            return new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return next.getKey();
                }

                @Override
                public V getValue() {
                    return ((CacheEntry)next.getValue()).getValue();
                }

                @Override
                public V setValue(V value) {
                    return ((CacheEntry)next.getValue()).setValue(value);
                }
            };
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next() not called");
            }
            LRUCache.this.remove(this.last.key());
        }

        public WrappedIterator(Iterator<Map.Entry<K, CacheEntry<K, V>>> iterator) {
            this.iterator = iterator;
        }
    }

    private class WrappedEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private Set<Map.Entry<K, CacheEntry<K, V>>> set;

        public WrappedEntrySet(Set<Map.Entry<K, CacheEntry<K, V>>> set) {
            this.set = set;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new WrappedIterator(this.set.iterator());
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = LRUCache.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return LRUCache.this.remove(e.getKey()) != null;
        }

        @Override
        public boolean isEmpty() {
            return LRUCache.this.isEmpty();
        }

        @Override
        public void clear() {
            LRUCache.this.clear();
        }
    }

    public static final class CacheEntry<K, V> {
        private static final Object CLAIM_TOKEN = new Object();
        private static final Object TOKEN_AVAILABLE = new Object();
        private static final Object DEAD_TOKEN = new Object();
        private static final AtomicIntegerFieldUpdater<CacheEntry> hitsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "hits");
        private static final AtomicReferenceFieldUpdater<CacheEntry, Object> tokenUpdater = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, Object.class, "tokenState");
        private static final AtomicReferenceFieldUpdater<CacheEntry, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, Object.class, "value");
        private final K key;
        private volatile V value;
        private volatile int hits = 1;
        private volatile Object tokenState = TOKEN_AVAILABLE;
        private volatile Object accessToken;

        private CacheEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        public boolean setValue(V oldValue, V newValue) {
            return valueUpdater.compareAndSet(this, oldValue, newValue);
        }

        public V getValue() {
            return this.value;
        }

        public int hit() {
            int i;
            do {
                i = this.hits;
            } while (!hitsUpdater.weakCompareAndSet(this, i++, i));
            return i;
        }

        public K key() {
            return this.key;
        }

        Object claimToken() {
            do {
                if (this.tokenState != DEAD_TOKEN) continue;
                return Boolean.FALSE;
            } while (!tokenUpdater.compareAndSet(this, TOKEN_AVAILABLE, CLAIM_TOKEN));
            return this.accessToken;
        }

        Object killToken() {
            Object old = this.claimToken();
            this.tokenState = DEAD_TOKEN;
            return old;
        }

        boolean setToken(Object token) {
            this.accessToken = token;
            this.tokenState = TOKEN_AVAILABLE;
            return true;
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

