/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.util.HashMap;
import org.wildfly.common.Assert;
import org.wildfly.security.util.ElytronMessages;

public final class StringEnumeration {
    private final HashMap<String, Data> index;
    private final Data[] byId;

    private StringEnumeration(HashMap<String, Data> index, Data[] byId) {
        this.index = index;
        this.byId = byId;
    }

    public static StringEnumeration of(String ... values) {
        int length = values.length;
        Data[] byId = new Data[length];
        HashMap<String, Data> index = new HashMap<String, Data>(length);
        for (int i = 0; i < length; ++i) {
            String str = (String)Assert.checkNotNullArrayParam((String)"values", (int)i, (Object)values[i]);
            byId[i] = new Data(i, str);
            index.put(str, byId[i]);
        }
        return new StringEnumeration(index, byId);
    }

    public String canonicalName(String str) {
        Data data = this.index.get(str);
        if (data == null) {
            throw ElytronMessages.log.generalInvalidName(str);
        }
        return data.canonicalName;
    }

    public int indexOf(String str) {
        Data data = this.index.get(str);
        if (data == null) {
            throw ElytronMessages.log.generalInvalidName(str);
        }
        return data.index;
    }

    public String nameOf(int index) {
        Data[] byId = this.byId;
        Assert.checkMinimumParameter((String)"index", (int)0, (int)index);
        Assert.checkMaximumParameter((String)"index", (int)(this.size() - 1), (int)index);
        return byId[index].canonicalName;
    }

    public int size() {
        return this.byId.length;
    }

    static class Data {
        final int index;
        final String canonicalName;

        Data(int index, String canonicalName) {
            this.index = index;
            this.canonicalName = canonicalName;
        }
    }
}

