/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.impl.ServerProducerImpl;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.client.ProtonClientSenderContext;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpTransferTagGenerator;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionHandler;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.jboss.logging.Logger;

public class AMQPSessionContext
extends ProtonInitializable {
    private static final Logger log = Logger.getLogger(AMQPSessionContext.class);
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionCallback sessionSPI;
    protected final Session session;
    protected Map<Receiver, ProtonServerReceiverContext> receivers = new ConcurrentHashMap<Receiver, ProtonServerReceiverContext>();
    protected Map<Sender, ProtonServerSenderContext> senders = new ConcurrentHashMap<Sender, ProtonServerSenderContext>();
    protected boolean closed = false;
    protected final AmqpTransferTagGenerator tagCache = new AmqpTransferTagGenerator();
    protected Map<Object, ProtonServerSenderContext> serverSenders = new ConcurrentHashMap<Object, ProtonServerSenderContext>();

    public AMQPSessionContext(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, Session session) {
        this.connection = connection;
        this.sessionSPI = sessionSPI;
        this.session = session;
    }

    @Override
    public void initialise() throws Exception {
        if (!this.isInitialized()) {
            super.initialise();
            if (this.sessionSPI != null) {
                try {
                    this.sessionSPI.init(this, this.connection.getSASLResult());
                }
                catch (ActiveMQSecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
            }
        }
    }

    public void disconnect(Object consumer, String queueName) {
        ProtonServerSenderContext protonConsumer = this.senders.remove(consumer);
        if (protonConsumer != null) {
            try {
                protonConsumer.close(false);
            }
            catch (ActiveMQAMQPException e) {
                protonConsumer.getSender().setTarget(null);
                protonConsumer.getSender().setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            }
        }
    }

    public byte[] getTag() {
        return this.tagCache.getNextTag();
    }

    public void replaceTag(byte[] tag) {
        this.tagCache.returnTag(tag);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        HashSet<ProtonServerReceiverContext> receiversCopy = new HashSet<ProtonServerReceiverContext>();
        receiversCopy.addAll(this.receivers.values());
        for (ProtonServerReceiverContext protonServerReceiverContext : receiversCopy) {
            try {
                protonServerReceiverContext.close(false);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.receivers.clear();
        HashSet<ProtonServerSenderContext> protonSendersClone = new HashSet<ProtonServerSenderContext>();
        protonSendersClone.addAll(this.senders.values());
        for (ProtonServerSenderContext protonConsumer : protonSendersClone) {
            try {
                protonConsumer.close(false);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.senders.clear();
        try {
            if (this.sessionSPI != null) {
                this.sessionSPI.close();
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        this.closed = true;
    }

    public void removeReceiver(Receiver receiver) {
        this.sessionSPI.removeProducer(receiver.getName());
        this.receivers.remove(receiver);
    }

    public void addTransactionHandler(Coordinator coordinator, Receiver receiver) {
        ProtonTransactionHandler transactionHandler = new ProtonTransactionHandler(this.sessionSPI, this.connection);
        coordinator.setCapabilities(new Symbol[]{Symbol.getSymbol((String)"amqp:local-transactions"), Symbol.getSymbol((String)"amqp:multi-txns-per-ssn"), Symbol.getSymbol((String)"amqp:multi-ssns-per-txn")});
        receiver.setContext((Object)transactionHandler);
        this.connection.runNow(() -> {
            receiver.open();
            receiver.flow(this.connection.getAmqpCredits());
            this.connection.flush();
        });
    }

    public void addSender(Sender sender) throws Exception {
        boolean outgoing = sender.getContext() != null && sender.getContext().equals(true);
        ProtonServerSenderContext protonSender = outgoing ? new ProtonClientSenderContext(this.connection, sender, this, this.sessionSPI) : new ProtonServerSenderContext(this.connection, sender, this, this.sessionSPI);
        try {
            protonSender.initialise();
            this.senders.put(sender, protonSender);
            this.serverSenders.put(protonSender.getBrokerConsumer(), protonSender);
            sender.setContext((Object)protonSender);
            this.connection.runNow(() -> {
                sender.open();
                this.connection.flush();
            });
            protonSender.start();
        }
        catch (ActiveMQAMQPException e) {
            this.senders.remove(sender);
            sender.setSource(null);
            sender.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            this.connection.runNow(() -> {
                sender.close();
                this.connection.flush();
            });
        }
    }

    public void removeSender(Sender sender) throws ActiveMQAMQPException {
        this.senders.remove(sender);
        ProtonServerSenderContext senderRemoved = this.senders.remove(sender);
        if (senderRemoved != null) {
            this.serverSenders.remove(senderRemoved.getBrokerConsumer());
        }
    }

    public void addReceiver(Receiver receiver) throws Exception {
        try {
            ProtonServerReceiverContext protonReceiver = new ProtonServerReceiverContext(this.sessionSPI, this.connection, this, receiver);
            protonReceiver.initialise();
            this.receivers.put(receiver, protonReceiver);
            ServerProducerImpl serverProducer = new ServerProducerImpl(receiver.getName(), "AMQP", receiver.getTarget().getAddress());
            this.sessionSPI.addProducer((ServerProducer)serverProducer);
            receiver.setContext((Object)protonReceiver);
            this.connection.runNow(() -> {
                receiver.open();
                this.connection.flush();
            });
        }
        catch (ActiveMQAMQPException e) {
            this.receivers.remove(receiver);
            receiver.setTarget(null);
            receiver.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            this.connection.runNow(() -> {
                receiver.close();
                this.connection.flush();
            });
        }
    }
}

