/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.util.List;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactProcessor;
import org.jboss.as.patching.validation.PatchingArtifactValidationContext;
import org.jboss.as.patching.validation.PatchingArtifacts;
import org.jboss.as.patching.validation.PatchingFileArtifact;
import org.jboss.as.patching.validation.PatchingXmlArtifact;

class PatchableTargetsArtifact
extends AbstractArtifact<PatchingXmlArtifact.XmlArtifactState<Patch>, PatchableTargetState> {
    PatchableTargetsArtifact(PatchingArtifact<PatchableTargetState, ? extends PatchingArtifact.ArtifactState> ... artifacts) {
        super(artifacts);
    }

    @Override
    public boolean process(PatchingXmlArtifact.XmlArtifactState<Patch> parent, PatchingArtifactProcessor processor) {
        InstalledIdentity identity = processor.getValidationContext().getInstalledIdentity();
        Patch patch = parent.getPatch();
        if ("base".equals(patch.getPatchId())) {
            return true;
        }
        List<PatchElement> elements = patch.getElements();
        boolean valid = true;
        if (elements != null && !elements.isEmpty()) {
            for (PatchElement element : elements) {
                PatchableTargetState state;
                String patchID = element.getId();
                PatchElementProvider provider = element.getProvider();
                String layerName = provider.getName();
                PatchableTarget target = provider.isAddOn() ? identity.getAddOn(layerName) : identity.getLayer(layerName);
                boolean modules = false;
                boolean bundles = false;
                for (ContentModification modification : element.getModifications()) {
                    if (modules && bundles) break;
                    if (modification.getItem().getContentType() == ContentType.BUNDLE) {
                        bundles = true;
                        continue;
                    }
                    if (modification.getItem().getContentType() != ContentType.MODULE) continue;
                    modules = true;
                }
                if (processor.process(PatchingArtifacts.LAYER, state = new PatchableTargetState(patchID, layerName, target, bundles, modules))) continue;
                valid = false;
            }
        }
        for (ContentModification modification : patch.getModifications()) {
            if (modification.getType() == ModificationType.ADD || modification.getItem().getContentType() != ContentType.MISC) continue;
            PatchingFileArtifact.DirectoryArtifactState history = processor.getParentArtifact(PatchingArtifacts.HISTORY_DIR);
            PatchingArtifacts.MISC_BACKUP.process(history, processor);
            break;
        }
        return valid;
    }

    static class PatchableTargetState
    implements PatchingArtifact.ArtifactState {
        private final String patchID;
        private final String layerName;
        private final PatchableTarget target;
        private final boolean checkBundles;
        private final boolean checkModules;

        PatchableTargetState(String patchID, String layerName, PatchableTarget target, boolean checkBundles, boolean checkModules) {
            this.patchID = patchID;
            this.layerName = layerName;
            this.target = target;
            this.checkBundles = checkBundles;
            this.checkModules = checkModules;
        }

        public String getPatchID() {
            return this.patchID;
        }

        public DirectoryStructure getStructure() {
            return this.target.getDirectoryStructure();
        }

        public boolean isCheckBundles() {
            return this.checkBundles;
        }

        public boolean isCheckModules() {
            return this.checkModules;
        }

        @Override
        public boolean isValid(PatchingArtifactValidationContext context) {
            if (this.target == null) {
                context.getErrorHandler().addMissing(PatchingArtifacts.PATCH_CONTENTS, this);
            }
            return true;
        }

        public String toString() {
            return this.layerName;
        }
    }
}

