/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.AbstractEnableSSLCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.OptionActivators;

@CommandDefinition(name="enable-ssl-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerEnableSSLCommand
extends AbstractEnableSSLCommand {
    @Option(name="server-name", completer=SecurityCommand.OptionCompleters.ServerNameCompleter.class)
    String serverName;
    @Option(name="no-override-security-realm", activator=OptionActivators.NoOverrideSecurityRealmActivator.class, hasValue=false)
    boolean noOverride;

    public HTTPServerEnableSSLCommand(CommandContext ctx) {
        super(ctx);
    }

    @Override
    protected void secure(CommandContext ctx, SSLSecurityBuilder builder) throws CommandException {
        try {
            HTTPServer.enableSSL(this.serverName, this.noOverride, ctx, builder);
        }
        catch (Exception ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected boolean isSSLEnabled(CommandContext ctx) throws Exception {
        String target = this.serverName;
        if (target == null) {
            target = DefaultResourceNames.getDefaultServerName(ctx);
        }
        return HTTPServer.getSSLContextName(target, ctx) != null;
    }

    @Override
    protected String getTarget(CommandContext ctx) {
        String target = this.serverName;
        if (target == null) {
            target = DefaultResourceNames.getDefaultServerName(ctx);
        }
        return target;
    }

    @Override
    String getDefaultKeyStoreFileName(CommandContext ctx) {
        return this.getTarget(ctx) + ".keystore";
    }

    @Override
    String getDefaultTrustStoreFileName(CommandContext ctx) {
        return this.getTarget(ctx) + ".truststore";
    }
}

