/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

class ServerRemove
extends AbstractRemoveStepHandler {
    static final ServerRemove INSTANCE = new ServerRemove();

    private ServerRemove() {
        super(new RuntimeCapability[]{Capabilities.ACTIVEMQ_SERVER_CAPABILITY});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String serverName = context.getCurrentAddressValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(serverName);
        context.removeService(JMSServices.getJmsManagerBaseServiceName(serviceName));
        context.removeService(MessagingServices.getActiveMQServiceName(serverName));
        if (model.hasDefined("broadcast-group")) {
            for (String name : model.get("broadcast-group").keys()) {
                context.removeService(GroupBindingService.getBroadcastBaseServiceName(serviceName).append(new String[]{name}));
            }
        }
        if (model.hasDefined("discovery-group")) {
            for (String name : model.get("discovery-group").keys()) {
                context.removeService(GroupBindingService.getDiscoveryBaseServiceName(serviceName).append(new String[]{name}));
            }
        }
    }
}

