/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.io.Serializable;
import java.security.Permission;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client._private.Log;

public final class LocalUserTransaction
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = -8082008006243656822L;
    private static final LocalUserTransaction instance = new LocalUserTransaction();

    private LocalUserTransaction() {
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkTransactionStateAvailability();
        ContextTransactionManager.getInstance().begin(CreationListener.CreatedBy.USER_TRANSACTION);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkTransactionStateAvailability();
        ContextTransactionManager.getInstance().commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkTransactionStateAvailability();
        ContextTransactionManager.getInstance().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkTransactionStateAvailability();
        ContextTransactionManager.getInstance().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        this.checkTransactionStateAvailability();
        return ContextTransactionManager.getInstance().getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.checkTransactionStateAvailability();
        ContextTransactionManager.getInstance().setTransactionTimeout(seconds);
    }

    public void setAvailability(boolean available) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)TransactionPermission.forName("modifyUserTransactionAvailability")));
        }
        ContextTransactionManager.getInstance().setAvailable(available);
    }

    public boolean isAvailable() {
        return ContextTransactionManager.getInstance().isAvailable();
    }

    Object readResolve() {
        return instance;
    }

    Object writeReplace() {
        return instance;
    }

    public static LocalUserTransaction getInstance() {
        return instance;
    }

    private void checkTransactionStateAvailability() {
        if (!this.isAvailable()) {
            throw Log.log.forbiddenContextForUserTransaction();
        }
    }
}

