/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.web.cache.SessionIdentifierSerializer;

public class SessionKeyExternalizer<K extends Key<String>>
implements Externalizer<K> {
    private final Class<K> targetClass;
    private final Function<String, K> resolver;

    protected SessionKeyExternalizer(Class<K> targetClass, Function<String, K> resolver) {
        this.targetClass = targetClass;
        this.resolver = resolver;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        SessionIdentifierSerializer.INSTANCE.write((DataOutput)output, (String)key.getValue());
    }

    public K readObject(ObjectInput input) throws IOException {
        return (K)((Key)this.resolver.apply(SessionIdentifierSerializer.INSTANCE.read((DataInput)input)));
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }
}

