/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.LineBreakHandler;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.operation.HeaderNameState;
import org.jboss.as.cli.parsing.operation.HeaderValueState;

public class HeaderState
extends DefaultParsingState {
    public static final HeaderState INSTANCE = new HeaderState();
    public static final String ID = "HEADER";

    HeaderState() {
        this(HeaderNameState.INSTANCE, HeaderValueState.INSTANCE);
    }

    HeaderState(HeaderNameState headerName, HeaderValueState headerValue) {
        super(ID);
        this.setIgnoreWhitespaces(true);
        this.setEnterHandler(new EnterStateCharacterHandler(headerName));
        this.putHandler(';', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.putHandler('}', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        final NameValueSeparatorState nameValueSep = new NameValueSeparatorState(headerValue);
        this.enterState('=', nameValueSep);
        this.setDefaultHandler(new EnterStateCharacterHandler(headerValue));
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                char ch = ctx.getCharacter();
                if (ch == '=') {
                    ctx.enterState(nameValueSep);
                } else if (!Character.isWhitespace(ch) && ch != '\\') {
                    ctx.leaveState();
                }
            }
        });
    }

    private static class NameValueSeparatorState
    extends DefaultParsingState {
        NameValueSeparatorState(final HeaderValueState valueState) {
            super("NAME_VALUE_SEPARATOR");
            this.setDefaultHandler(new LineBreakHandler(false, false){

                @Override
                protected void doHandle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(valueState);
                }
            });
            this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
            this.setIgnoreWhitespaces(true);
        }
    }
}

