/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.wildfly.core.embedded.Context;
import org.wildfly.core.embedded.SecurityActions;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

abstract class SystemPropertyContext
implements Context {
    private static final String HOME_DIR = "jboss.home.dir";
    private static final String HOST_NAME = "jboss.host.name";
    private static final String NODE_NAME = "jboss.node.name";
    private static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    private static final String SERVER_NAME = "jboss.server.name";
    private final Path jbossHomeDir;
    private final Map<String, String> propertiesToReset = new HashMap<String, String>();
    private final Set<String> propertiesToClear = new HashSet<String>();

    SystemPropertyContext(Path jbossHomeDir) {
        if (jbossHomeDir == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHomeDir");
        }
        this.jbossHomeDir = jbossHomeDir;
    }

    @Override
    public void activate() {
        this.addOrReplaceProperty(HOME_DIR, this.jbossHomeDir);
        this.checkProperty("jboss.server.persist.config");
        this.checkProperty(HOST_NAME);
        this.checkProperty(NODE_NAME);
        this.checkProperty(QUALIFIED_HOST_NAME);
        this.checkProperty(SERVER_NAME);
        this.checkProperty("org.jboss.resolver.warning");
        this.configureProperties();
    }

    @Override
    public void restore() {
        Iterator<String> toClear = this.propertiesToClear.iterator();
        while (toClear.hasNext()) {
            SecurityActions.clearPropertyPrivileged(toClear.next());
            toClear.remove();
        }
        Iterator<Map.Entry<String, String>> toReset = this.propertiesToReset.entrySet().iterator();
        while (toReset.hasNext()) {
            Map.Entry<String, String> entry = toReset.next();
            SecurityActions.setPropertyPrivileged(entry.getKey(), entry.getValue());
            toReset.remove();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(propertiesToReset=" + this.propertiesToReset + ", propertiesToClear=" + this.propertiesToClear + ")";
    }

    abstract void configureProperties();

    void addOrReplaceProperty(String name, Object value) {
        String currentValue = SecurityActions.setPropertyPrivileged(name, value.toString());
        if (currentValue != null) {
            this.propertiesToReset.put(name, currentValue);
        } else {
            this.propertiesToClear.add(name);
        }
    }

    void addPropertyIfAbsent(String name, Object value) {
        String currentValue = SecurityActions.getPropertyPrivileged(name);
        if (currentValue == null) {
            SecurityActions.setPropertyPrivileged(name, value.toString());
            this.propertiesToClear.add(name);
        }
    }

    void checkProperty(String name) {
        if (SecurityActions.getPropertyPrivileged(name) == null) {
            this.propertiesToClear.add(name);
        }
    }

    Path resolveBaseDir(String name, String dirName) {
        String currentDir = SecurityActions.getPropertyPrivileged(name);
        if (currentDir == null) {
            return this.jbossHomeDir.resolve(dirName);
        }
        return Paths.get(currentDir, new String[0]);
    }

    static Path resolvePath(Path base, String ... paths) {
        return Paths.get(base.toString(), paths);
    }
}

