/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.AdminOperation;
import org.infinispan.client.hotrod.impl.operations.AuthMechListOperation;
import org.infinispan.client.hotrod.impl.operations.AuthOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.CompleteTransactionOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.FaultTolerantPingOperation;
import org.infinispan.client.hotrod.impl.operations.ForgetTransactionOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.IterationEndOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PrepareTransactionOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamOperation;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.impl.operations.RecoveryOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

@Immutable
public class OperationsFactory
implements HotRodConstants {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final ChannelFactory channelFactory;
    private final byte[] cacheNameBytes;
    private final AtomicInteger topologyId;
    private final boolean forceReturnValue;
    private final Codec codec;
    private final ClientListenerNotifier listenerNotifier;
    private final String cacheName;
    private final Configuration cfg;
    private final ClientStatistics clientStatistics;

    public OperationsFactory(ChannelFactory channelFactory, String cacheName, boolean forceReturnValue, Codec codec, ClientListenerNotifier listenerNotifier, Configuration cfg, ClientStatistics clientStatistics) {
        this.channelFactory = channelFactory;
        this.cacheNameBytes = cacheName == null ? DEFAULT_CACHE_NAME_BYTES : RemoteCacheManager.cacheNameBytes(cacheName);
        this.cacheName = cacheName;
        this.topologyId = channelFactory != null ? channelFactory.createTopologyId(this.cacheNameBytes) : new AtomicInteger(-1);
        this.forceReturnValue = forceReturnValue;
        this.codec = codec;
        this.listenerNotifier = listenerNotifier;
        this.cfg = cfg;
        this.clientStatistics = clientStatistics;
    }

    public OperationsFactory(ChannelFactory channelFactory, Codec codec, ClientListenerNotifier listenerNotifier, Configuration cfg) {
        this(channelFactory, null, false, codec, listenerNotifier, cfg, null);
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public <V> GetOperation<V> newGetKeyOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new GetOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public <K, V> GetAllParallelOperation<K, V> newGetAllOperation(Set<byte[]> keys, DataFormat dataFormat) {
        return new GetAllParallelOperation(this.codec, this.channelFactory, keys, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public <V> RemoveOperation<V> newRemoveOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new RemoveOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public <V> RemoveIfUnmodifiedOperation<V> newRemoveIfUnmodifiedOperation(Object key, byte[] keyBytes, long version, DataFormat dataFormat) {
        return new RemoveIfUnmodifiedOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, version, dataFormat, this.clientStatistics);
    }

    public ReplaceIfUnmodifiedOperation newReplaceIfUnmodifiedOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version, DataFormat dataFormat) {
        return new ReplaceIfUnmodifiedOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version, dataFormat, this.clientStatistics);
    }

    public <V> GetWithVersionOperation<V> newGetWithVersionOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new GetWithVersionOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public <V> GetWithMetadataOperation<V> newGetWithMetadataOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new GetWithMetadataOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public StatsOperation newStatsOperation() {
        return new StatsOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <V> PutOperation<V> newPutKeyValueOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new PutOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, this.clientStatistics);
    }

    public PutAllParallelOperation newPutAllOperation(Map<byte[], byte[]> map, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new PutAllParallelOperation(this.codec, this.channelFactory, map, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.cfg, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, this.clientStatistics);
    }

    public <V> PutIfAbsentOperation<V> newPutIfAbsentOperation(Object key, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new PutIfAbsentOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdleTime), this.cfg, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, dataFormat, this.clientStatistics);
    }

    public <V> ReplaceOperation<V> newReplaceOperation(Object key, byte[] keyBytes, byte[] values, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat) {
        return new ReplaceOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), this.cfg, values, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, this.clientStatistics);
    }

    public ContainsKeyOperation newContainsKeyOperation(Object key, byte[] keyBytes, DataFormat dataFormat) {
        return new ContainsKeyOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, dataFormat, this.clientStatistics);
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <K, V> BulkGetOperation<K, V> newBulkGetOperation(int size, DataFormat dataFormat) {
        return new BulkGetOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, size, dataFormat, this.clientStatistics);
    }

    public <K> BulkGetKeysOperation<K> newBulkGetKeysOperation(int scope, DataFormat dataFormat) {
        return new BulkGetKeysOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, scope, dataFormat, this.clientStatistics);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, DataFormat dataFormat) {
        return new AddClientListenerOperation(this.codec, this.channelFactory, this.cacheName, this.topologyId, this.flags(), this.cfg, this.listenerNotifier, listener, null, null, dataFormat);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat) {
        return new AddClientListenerOperation(this.codec, this.channelFactory, this.cacheName, this.topologyId, this.flags(), this.cfg, this.listenerNotifier, listener, filterFactoryParams, converterFactoryParams, dataFormat);
    }

    public RemoveClientListenerOperation newRemoveClientListenerOperation(Object listener) {
        return new RemoveClientListenerOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, this.listenerNotifier, listener);
    }

    public PingOperation newPingOperation(boolean releaseChannel) {
        return new PingOperation(this.codec, this.topologyId, this.cfg, this.cacheNameBytes, this.channelFactory, releaseChannel);
    }

    public FaultTolerantPingOperation newFaultTolerantPingOperation() {
        return new FaultTolerantPingOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public QueryOperation newQueryOperation(RemoteQuery remoteQuery, DataFormat dataFormat) {
        return new QueryOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, remoteQuery, dataFormat);
    }

    public SizeOperation newSizeOperation() {
        return new SizeOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg);
    }

    public <T> ExecuteOperation<T> newExecuteOperation(String taskName, Map<String, byte[]> marshalledParams, Object key, DataFormat dataFormat) {
        return new ExecuteOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, taskName, marshalledParams, key, dataFormat);
    }

    public AdminOperation newAdminOperation(String taskName, Map<String, byte[]> marshalledParams) {
        return new AdminOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, taskName, marshalledParams);
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= Flag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= Flag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        if (this.forceReturnValue) {
            intFlags |= Flag.FORCE_RETURN_VALUE.getFlagInt();
        }
        return intFlags;
    }

    public void setFlags(Flag[] flags) {
        int intFlags = 0;
        for (Flag flag : flags) {
            intFlags |= flag.getFlagInt();
        }
        this.flagsMap.set(intFlags);
    }

    public void setFlags(int intFlags) {
        this.flagsMap.set(intFlags);
    }

    public boolean hasFlag(Flag flag) {
        Integer threadLocalFlags = this.flagsMap.get();
        return threadLocalFlags != null && (threadLocalFlags & flag.getFlagInt()) != 0;
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.channelFactory.getCacheTopologyInfo(this.cacheNameBytes);
    }

    public IterationStartOperation newIterationStartOperation(String filterConverterFactory, byte[][] filterParameters, Set<Integer> segments, int batchSize, boolean metadata, DataFormat dataFormat) {
        return new IterationStartOperation(this.codec, this.flags(), this.cfg, this.cacheNameBytes, this.topologyId, filterConverterFactory, filterParameters, segments, batchSize, this.channelFactory, metadata, dataFormat);
    }

    public IterationEndOperation newIterationEndOperation(byte[] iterationId, Channel channel) {
        return new IterationEndOperation(this.codec, this.flags(), this.cfg, this.cacheNameBytes, this.topologyId, iterationId, this.channelFactory, channel);
    }

    public <E> IterationNextOperation<E> newIterationNextOperation(byte[] iterationId, Channel channel, KeyTracker segmentKeyTracker, DataFormat dataFormat) {
        return new IterationNextOperation(this.codec, this.flags(), this.cfg, this.cacheNameBytes, this.topologyId, iterationId, channel, this.channelFactory, segmentKeyTracker, dataFormat);
    }

    public <K> GetStreamOperation newGetStreamOperation(K key, byte[] keyBytes, int offset) {
        return new GetStreamOperation(this.codec, this.channelFactory, key, keyBytes, offset, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, this.clientStatistics);
    }

    public <K> PutStreamOperation newPutStreamOperation(K key, byte[] keyBytes, long version, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, version, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.clientStatistics);
    }

    public <K> PutStreamOperation newPutStreamOperation(K key, byte[] keyBytes, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, 0L, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.clientStatistics);
    }

    public <K> PutStreamOperation newPutIfAbsentStreamOperation(K key, byte[] keyBytes, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new PutStreamOperation(this.codec, this.channelFactory, key, keyBytes, this.cacheNameBytes, this.topologyId, this.flags(), this.cfg, -1L, lifespan, lifespanUnit, maxIdle, maxIdleUnit, this.clientStatistics);
    }

    public AuthMechListOperation newAuthMechListOperation(Channel channel) {
        return new AuthMechListOperation(this.codec, this.topologyId, this.cfg, channel, this.channelFactory);
    }

    public AuthOperation newAuthOperation(Channel channel, String saslMechanism, byte[] response) {
        return new AuthOperation(this.codec, this.topologyId, this.cfg, channel, this.channelFactory, saslMechanism, response);
    }

    public PrepareTransactionOperation newPrepareTransactionOperation(Xid xid, boolean onePhaseCommit, Collection<Modification> modifications, boolean recoverable, long timeoutMs) {
        return new PrepareTransactionOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.cfg, xid, onePhaseCommit, modifications, recoverable, timeoutMs);
    }

    public CompleteTransactionOperation newCompleteTransactionOperation(Xid xid, boolean commit) {
        return new CompleteTransactionOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.cfg, xid, commit);
    }

    public ForgetTransactionOperation newForgetTransactionOperation(Xid xid) {
        return new ForgetTransactionOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.cfg, xid);
    }

    public RecoveryOperation newRecoveryOperation() {
        return new RecoveryOperation(this.codec, this.channelFactory, this.cacheNameBytes, this.topologyId, this.cfg);
    }
}

