/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJBStatistics;
import org.jboss.dmr.ModelNode;

class StatisticsEnabledWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    static StatisticsEnabledWriteHandler INSTANCE = new StatisticsEnabledWriteHandler();

    StatisticsEnabledWriteHandler() {
        super(new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.STATISTICS_ENABLED});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateToRuntime(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateToRuntime(context, restored);
    }

    void updateToRuntime(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean statisticsEnabled = EJB3SubsystemRootResourceDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        EJBStatistics.getInstance().setEnabled(statisticsEnabled);
    }
}

