/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.BooleanExternalizer;
import org.wildfly.clustering.marshalling.spi.EnumExternalizer;
import org.wildfly.clustering.marshalling.spi.IntExternalizer;
import org.wildfly.clustering.marshalling.spi.LongExternalizer;
import org.wildfly.clustering.marshalling.spi.ObjectExternalizer;
import org.wildfly.clustering.marshalling.spi.StringExternalizer;
import org.wildfly.clustering.marshalling.spi.ValueExternalizer;
import org.wildfly.clustering.marshalling.spi.net.InetAddressExternalizer;
import org.wildfly.clustering.marshalling.spi.net.InetSocketAddressExternalizer;
import org.wildfly.clustering.marshalling.spi.net.URLExternalizer;
import org.wildfly.clustering.marshalling.spi.time.DurationExternalizer;
import org.wildfly.clustering.marshalling.spi.time.InstantExternalizer;
import org.wildfly.clustering.marshalling.spi.time.LocalDateTimeExternalizer;
import org.wildfly.clustering.marshalling.spi.time.MonthDayExternalizer;
import org.wildfly.clustering.marshalling.spi.time.PeriodExternalizer;
import org.wildfly.clustering.marshalling.spi.time.YearMonthExternalizer;
import org.wildfly.clustering.marshalling.spi.util.CalendarExternalizer;
import org.wildfly.clustering.marshalling.spi.util.CollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.CopyOnWriteCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.DateExternalizer;
import org.wildfly.clustering.marshalling.spi.util.HashMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.LinkedHashMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.MapEntryExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SingletonCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SingletonMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SortedMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SortedSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UUIDExternalizer;

public enum DefaultExternalizer implements Externalizer<Object>
{
    INET_ADDRESS(new InetAddressExternalizer<InetAddress>(InetAddress.class, OptionalInt.empty())),
    INET4_ADDRESS(new InetAddressExternalizer<Inet4Address>(Inet4Address.class, OptionalInt.of(4))),
    INET6_ADDRESS(new InetAddressExternalizer<Inet6Address>(Inet6Address.class, OptionalInt.of(16))),
    INET_SOCKET_ADDRESS(new InetSocketAddressExternalizer()),
    URI(new StringExternalizer<URI>(URI.class, URI::create, URI::toString)),
    URL(new URLExternalizer()),
    DAY_OF_WEEK(new EnumExternalizer<DayOfWeek>(DayOfWeek.class)),
    DURATION(new DurationExternalizer()),
    INSTANT(new InstantExternalizer()),
    LOCAL_DATE(new LongExternalizer<LocalDate>(LocalDate.class, LocalDate::ofEpochDay, LocalDate::toEpochDay)),
    LOCAL_DATE_TIME(new LocalDateTimeExternalizer()),
    LOCAL_TIME(new LongExternalizer<LocalTime>(LocalTime.class, LocalTime::ofNanoOfDay, LocalTime::toNanoOfDay)),
    MONTH(new EnumExternalizer<Month>(Month.class)),
    MONTH_DAY(new MonthDayExternalizer()),
    PERIOD(new PeriodExternalizer()),
    YEAR(new IntExternalizer<Year>(Year.class, Year::of, Year::getValue)),
    YEAR_MONTH(new YearMonthExternalizer()),
    ZONE_ID(new StringExternalizer<ZoneId>(ZoneId.class, ZoneId::of, ZoneId::getId)),
    ZONE_OFFSET(new StringExternalizer<ZoneOffset>(ZoneOffset.class, ZoneOffset::of, ZoneOffset::getId)),
    ARRAY_DEQUE(new CollectionExternalizer<ArrayDeque>(ArrayDeque.class, ArrayDeque::new)),
    ARRAY_LIST(new CollectionExternalizer<ArrayList>(ArrayList.class, ArrayList::new)),
    ATOMIC_BOOLEAN(new BooleanExternalizer<AtomicBoolean>(AtomicBoolean.class, AtomicBoolean::new, AtomicBoolean::get)),
    ATOMIC_INTEGER(new IntExternalizer<AtomicInteger>(AtomicInteger.class, AtomicInteger::new, AtomicInteger::get)),
    ATOMIC_LONG(new LongExternalizer<AtomicLong>(AtomicLong.class, AtomicLong::new, AtomicLong::get)),
    ATOMIC_REFERENCE(new ObjectExternalizer<AtomicReference>(AtomicReference.class, AtomicReference::new, AtomicReference::get)),
    CALENDAR(new CalendarExternalizer()),
    CONCURRENT_HASH_MAP(new HashMapExternalizer<ConcurrentHashMap>(ConcurrentHashMap.class, ConcurrentHashMap::new)),
    CONCURRENT_HASH_SET(new CollectionExternalizer<ConcurrentHashMap.KeySetView>(ConcurrentHashMap.KeySetView.class, ConcurrentHashMap::newKeySet)),
    CONCURRENT_LINKED_DEQUE(new CollectionExternalizer<ConcurrentLinkedDeque>(ConcurrentLinkedDeque.class, size -> new ConcurrentLinkedDeque())),
    CONCURRENT_LINKED_QUEUE(new CollectionExternalizer<ConcurrentLinkedQueue>(ConcurrentLinkedQueue.class, size -> new ConcurrentLinkedQueue())),
    CONCURRENT_SKIP_LIST_MAP(new SortedMapExternalizer<ConcurrentSkipListMap>((Class<?>)ConcurrentSkipListMap.class, (Function<Comparator<Object>, ConcurrentSkipListMap>)((Function<Comparator, ConcurrentSkipListMap>)ConcurrentSkipListMap::new))),
    CONCURRENT_SKIP_LIST_SET(new SortedSetExternalizer<ConcurrentSkipListSet>(ConcurrentSkipListSet.class, ConcurrentSkipListSet::new)),
    COPY_ON_WRITE_ARRAY_LIST(new CopyOnWriteCollectionExternalizer<CopyOnWriteArrayList>(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new)),
    COPY_ON_WRITE_ARRAY_SET(new CopyOnWriteCollectionExternalizer<CopyOnWriteArraySet>(CopyOnWriteArraySet.class, CopyOnWriteArraySet::new)),
    CURRENCY(new StringExternalizer<Currency>(Currency.class, Currency::getInstance, Currency::getCurrencyCode)),
    DATE(new DateExternalizer<java.util.Date>(java.util.Date.class, java.util.Date::new)),
    EMPTY_ENUMERATION(new ValueExternalizer<Enumeration<T>>(Collections.emptyEnumeration())),
    EMPTY_ITERATOR(new ValueExternalizer<Iterator<T>>(Collections.emptyIterator())),
    EMPTY_LIST(new ValueExternalizer<List<T>>(Collections.emptyList())),
    EMPTY_LIST_ITERATOR(new ValueExternalizer<ListIterator<T>>(Collections.emptyListIterator())),
    EMPTY_MAP(new ValueExternalizer<Map<K, V>>(Collections.emptyMap())),
    EMPTY_NAVIGABLE_MAP(new ValueExternalizer<NavigableMap<K, V>>(Collections.emptyNavigableMap())),
    EMPTY_NAVIGABLE_SET(new ValueExternalizer<NavigableSet<E>>(Collections.emptyNavigableSet())),
    EMPTY_SET(new ValueExternalizer<Set<T>>(Collections.emptySet())),
    EMPTY_SORTED_MAP(new ValueExternalizer<SortedMap<K, V>>(Collections.emptySortedMap())),
    EMPTY_SORTED_SET(new ValueExternalizer<SortedSet<E>>(Collections.emptySortedSet())),
    HASH_MAP(new HashMapExternalizer<HashMap>(HashMap.class, HashMap::new)),
    HASH_SET(new CollectionExternalizer<HashSet>(HashSet.class, HashSet::new)),
    LINKED_HASH_MAP(new LinkedHashMapExternalizer()),
    LINKED_HASH_SET(new CollectionExternalizer<LinkedHashSet>(LinkedHashSet.class, LinkedHashSet::new)),
    LINKED_LIST(new CollectionExternalizer<LinkedList>(LinkedList.class, size -> new LinkedList())),
    LOCALE(new StringExternalizer<Locale>(Locale.class, Locale::forLanguageTag, Locale::toLanguageTag)),
    NATURAL_ORDER_COMPARATOR(new ValueExternalizer<Comparator<T>>(Comparator.naturalOrder())),
    OPTIONAL(new ObjectExternalizer<Optional>(Optional.class, Optional::ofNullable, optional -> optional.orElse(null))),
    REVERSE_ORDER_COMPARATOR(new ValueExternalizer<Comparator<T>>(Collections.reverseOrder())),
    SIMPLE_ENTRY(new MapEntryExternalizer<AbstractMap.SimpleEntry>(AbstractMap.SimpleEntry.class, AbstractMap.SimpleEntry::new)),
    SIMPLE_IMMUTABLE_ENTRY(new MapEntryExternalizer<AbstractMap.SimpleImmutableEntry>(AbstractMap.SimpleImmutableEntry.class, AbstractMap.SimpleImmutableEntry::new)),
    SINGLETON_LIST(new SingletonCollectionExternalizer<List>(Collections::singletonList)),
    SINGLETON_MAP(new SingletonMapExternalizer()),
    SINGLETON_SET(new SingletonCollectionExternalizer<Set>(Collections::singleton)),
    SQL_DATE(new DateExternalizer<Date>(Date.class, Date::new)),
    SQL_TIME(new DateExternalizer<Time>(Time.class, Time::new)),
    SQL_TIMESTAMP(new DateExternalizer.SqlTimestampExternalizer()),
    TIME_UNIT(new EnumExternalizer<TimeUnit>(TimeUnit.class)),
    TIME_ZONE(new StringExternalizer<TimeZone>(TimeZone.class, TimeZone::getTimeZone, TimeZone::getID)),
    TREE_MAP(new SortedMapExternalizer<TreeMap>((Class<?>)TreeMap.class, (Function<Comparator<Object>, TreeMap>)((Function<Comparator, TreeMap>)TreeMap::new))),
    TREE_SET(new SortedSetExternalizer<TreeSet>(TreeSet.class, TreeSet::new)),
    UUID(new UUIDExternalizer());

    private final Externalizer<Object> externalizer;

    private DefaultExternalizer(Externalizer<?> externalizer) {
        this.externalizer = externalizer;
    }

    public void writeObject(ObjectOutput output, Object object) throws IOException {
        this.externalizer.writeObject(output, object);
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.externalizer.readObject(input);
    }

    public Class<Object> getTargetClass() {
        return this.externalizer.getTargetClass();
    }

    public <T> Externalizer<T> cast(Class<T> type) {
        if (!type.isAssignableFrom(this.externalizer.getTargetClass())) {
            throw new IllegalArgumentException(type.getName());
        }
        return this.externalizer;
    }
}

