/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.PasswordAction;
import org.apache.activemq.artemis.cli.commands.util.HashUtil;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModuleConfigurator;
import org.apache.commons.lang3.StringUtils;

@Command(name="reset", description="Reset user's password or roles")
public class ResetUser
extends PasswordAction {
    @Option(name={"--plaintext"}, description="using plaintext (Default false)")
    boolean plaintext = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.checkInputUser();
        this.checkInputPassword();
        if (this.password != null) {
            this.password = this.plaintext ? this.password : HashUtil.tryHash(context, this.password);
        }
        String[] roles = null;
        if (this.role != null) {
            roles = StringUtils.split((String)this.role, (String)",");
        }
        this.reset(this.password, roles);
        return null;
    }

    private void reset(String password, String[] roles) throws Exception {
        if (password == null && roles == null) {
            this.context.err.println("Nothing to update.");
            return;
        }
        PropertiesLoginModuleConfigurator config = new PropertiesLoginModuleConfigurator(this.entry, this.getBrokerEtc());
        config.updateUser(this.username, password, roles);
        config.save();
        this.context.out.println("User updated");
    }
}

