/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.util;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Tracer<V>
implements FaultToleranceStrategy<V> {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final FaultToleranceStrategy<V> delegate;

    public Tracer(FaultToleranceStrategy<V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        System.out.println(df.format(new Date()) + " [" + Thread.currentThread().getName() + "] invoking " + this.delegate.getClass().getSimpleName());
        try {
            V v = this.delegate.apply(ctx);
            return v;
        }
        finally {
            System.out.println(df.format(new Date()) + " [" + Thread.currentThread().getName() + "] finished " + this.delegate.getClass().getSimpleName());
        }
    }
}

