/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.msc.service.StartException;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;

public abstract class UpdatePropertiesHandler {
    private ConsoleWrapper theConsole;

    public UpdatePropertiesHandler(ConsoleWrapper theConsole) {
        this.theConsole = theConsole;
    }

    void persist(String key, String value, boolean enableDisableMode, boolean disable, File file) throws IOException, StartException {
        this.persist(key, value, enableDisableMode, disable, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist(String key, String value, boolean enableDisableMode, boolean disable, File file, String realm) throws IOException, StartException {
        PropertiesFileLoader propertiesHandler = realm == null ? new PropertiesFileLoader(file.getAbsolutePath()) : new UserPropertiesFileLoader(file.getAbsolutePath());
        try {
            propertiesHandler.start(null);
            if (realm != null) {
                ((UserPropertiesFileLoader)propertiesHandler).setRealmName(realm);
            }
            Properties prob = propertiesHandler.getProperties();
            if (value != null) {
                prob.setProperty(key, value);
            }
            if (enableDisableMode) {
                prob.setProperty(key + "!disable", String.valueOf(disable));
            }
            propertiesHandler.persistProperties();
        }
        finally {
            propertiesHandler.stop(null);
        }
    }

    abstract String consoleUserMessage(String var1);

    abstract String consoleGroupsMessage(String var1);

    abstract String errorMessage(String var1, Throwable var2);

    State update(StateValues stateValues) {
        String password;
        String userName = stateValues.getUserName();
        boolean enableDisableMode = stateValues.getOptions().isEnableDisableMode();
        boolean disable = stateValues.getOptions().isDisable();
        String groups = stateValues.getGroups();
        if (stateValues.getPassword() != null) {
            try {
                password = new UsernamePasswordHashUtil().generateHashedHexURP(stateValues.getUserName(), stateValues.getRealm(), stateValues.getPassword().toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                return new ErrorState(this.theConsole, e.getMessage(), null, stateValues);
            }
        } else {
            password = null;
        }
        for (File current : stateValues.getUserFiles()) {
            try {
                this.persist(userName, password, enableDisableMode, disable, current, stateValues.getRealm());
                if (stateValues.isSilent()) continue;
                this.theConsole.printf(this.consoleUserMessage(current.getCanonicalPath()), new Object[0]);
                this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
            }
            catch (Exception e) {
                return new ErrorState(this.theConsole, this.errorMessage(current.getAbsolutePath(), e), null, stateValues);
            }
        }
        if (stateValues.groupPropertiesFound() && (groups != null || enableDisableMode)) {
            for (File current : stateValues.getGroupFiles()) {
                try {
                    this.persist(userName, groups, enableDisableMode, disable, current);
                    if (stateValues.isSilent()) continue;
                    this.theConsole.printf(this.consoleGroupsMessage(current.getCanonicalPath()), new Object[0]);
                    this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
                }
                catch (Exception e) {
                    return new ErrorState(this.theConsole, this.errorMessage(current.getAbsolutePath(), e), null, stateValues);
                }
            }
        }
        return null;
    }
}

