/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContext;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.util.sso.SingleSignOn;

public class DistributableSingleSignOn
implements SingleSignOn {
    private final SSO<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext> sso;
    private final Batcher<Batch> batcher;
    private final Batch batch;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public DistributableSingleSignOn(SSO<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext> sso, Batcher<Batch> batcher, Batch batch) {
        this.sso = sso;
        this.batcher = batcher;
        this.batch = batch;
    }

    public String getId() {
        return this.sso.getId();
    }

    public String getMechanism() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            String string = ((ElytronAuthentication)this.sso.getAuthentication()).getMechanism();
            return string;
        }
    }

    public String getName() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            String string = ((ElytronAuthentication)this.sso.getAuthentication()).getName();
            return string;
        }
    }

    public SecurityIdentity getIdentity() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            SecurityIdentity securityIdentity = ((LocalSSOContext)this.sso.getLocalContext()).getSecurityIdentity();
            return securityIdentity;
        }
    }

    public Map<String, Map.Entry<String, URI>> getParticipants() {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            Sessions sessions = this.sso.getSessions();
            HashMap<String, Object> participants = new HashMap<String, Object>();
            for (String deployment : sessions.getDeployments()) {
                participants.put(deployment, sessions.getSession((Object)deployment));
            }
            Map map = Collections.unmodifiableMap(participants);
            return map;
        }
    }

    public void setIdentity(SecurityIdentity identity) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            ((LocalSSOContext)this.sso.getLocalContext()).setSecurityIdentity(identity);
        }
    }

    public boolean addParticipant(String applicationId, String sessionId, URI participant) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            boolean bl = this.sso.getSessions().addSession((Object)applicationId, new AbstractMap.SimpleImmutableEntry<String, URI>(sessionId, participant));
            return bl;
        }
    }

    public Map.Entry<String, URI> removeParticipant(String applicationId) {
        try (BatchContext context = this.batcher.resumeBatch(this.batch);){
            Map.Entry entry = (Map.Entry)this.sso.getSessions().removeSession((Object)applicationId);
            return entry;
        }
    }

    public void invalidate() {
        try (BatchContext context = this.closed.compareAndSet(false, true) ? this.batcher.resumeBatch(this.batch) : null;
             Batch batch = context != null ? this.batch : this.batcher.createBatch();){
            this.sso.invalidate();
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try (BatchContext context = this.batcher.resumeBatch(this.batch);){
                this.batch.close();
            }
        }
    }
}

