/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.security.SecurityContext;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.picketlink.trust.jbossws.handler.SAAJHelper;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractSAML2Handler
extends AbstractPicketLinkTrustHandler {
    public static final String ROLE_KEY_SYS_PROP = "picketlink.rolekey";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean handleInbound(MessageContext msgContext) {
        logger.trace("Handling Inbound Message");
        String assertionNS = JBossSAMLURIConstants.ASSERTION_NSURI.get();
        SOAPMessageContext ctx = (SOAPMessageContext)msgContext;
        SOAPMessage soapMessage = ctx.getMessage();
        if (soapMessage == null) {
            throw logger.nullValueError("SOAP Message");
        }
        SOAPPart document = soapMessage.getSOAPPart();
        Element soapHeader = Util.findOrCreateSoapHeader(document.getDocumentElement());
        Element assertion = Util.findElement(soapHeader, new QName(assertionNS, "Assertion"));
        if (assertion == null) {
            logger.trace("We did not find any assertion");
            return true;
        }
        AssertionType assertionType = null;
        try {
            assertionType = SAMLUtil.fromElement((Element)assertion);
            if (!AssertionUtil.hasExpired((AssertionType)assertionType)) {
                // empty if block
            }
        }
        catch (Exception e) {
            logger.samlAssertionPasingFailed((Throwable)e);
        }
        SamlCredential credential = new SamlCredential(assertion);
        if (logger.isTraceEnabled()) {
            logger.trace("Assertion included in SOAP payload: " + credential.getAssertionAsString());
        }
        Element subject = Util.findElement(assertion, new QName(assertionNS, "Subject"));
        Element nameID = Util.findElement(subject, new QName(assertionNS, "NameID"));
        String username = this.getUsername(nameID);
        Subject theSubject = new Subject();
        PicketLinkPrincipal principal = new PicketLinkPrincipal(username);
        this.createSecurityContext(credential, theSubject, principal, msgContext);
        if (assertionType == null) return true;
        ArrayList roleKeys = new ArrayList();
        String roleKey = SecurityActions.getSystemProperty(ROLE_KEY_SYS_PROP, "Role");
        if (StringUtil.isNotNull((String)roleKey)) {
            roleKeys.addAll(StringUtil.tokenize((String)roleKey));
        }
        logger.trace("Rolekeys to extract roles from the assertion: " + roleKeys);
        List roles = AssertionUtil.getRoles((AssertionType)assertionType, roleKeys);
        if (roles.size() > 0) {
            logger.trace("Roles in the assertion: " + roles);
            Group roleGroup = SecurityActions.group(roles);
            theSubject.getPrincipals().add((Principal)roleGroup);
            return true;
        }
        logger.trace("Did not find roles in the assertion");
        return true;
    }

    protected void createSecurityContext(SamlCredential credential, Subject theSubject, Principal principal, MessageContext msgContext) {
        try {
            SecurityContext sc = SecurityActions.createSecurityContext(principal, credential, theSubject, this.getSecurityDomainName(msgContext));
            SecurityActions.setSecurityContext(sc);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean handleOutbound(MessageContext msgContext) {
        logger.trace("Handling Outbound Message");
        SOAPMessageContext ctx = (SOAPMessageContext)msgContext;
        SOAPMessage soapMessage = ctx.getMessage();
        Element assertion = (Element)ctx.get((Object)"org.picketlink.trust.saml.assertion");
        if (assertion == null) {
            assertion = this.getAssertionFromSubject();
        }
        if (assertion == null) {
            logger.trace("We did not find any assertion");
            return true;
        }
        SOAPPart document = soapMessage.getSOAPPart();
        Element soapHeader = Util.findOrCreateSoapHeader(document.getDocumentElement());
        try {
            Element wsse = this.getSecurityHeaderElement((Document)document);
            wsse = (Element)SAAJHelper.getDomElement(wsse);
            wsse.setAttributeNS(soapHeader.getNamespaceURI(), soapHeader.getPrefix() + ":mustUnderstand", "1");
            if (assertion != null) {
                if (document.getDocumentElement().getOwnerDocument() != assertion.getOwnerDocument()) {
                    wsse.appendChild(document.getDocumentElement().getOwnerDocument().importNode(assertion, true));
                } else {
                    wsse.appendChild(assertion);
                }
            }
            soapHeader.insertBefore(wsse, soapHeader.getFirstChild());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        return true;
    }
}

