/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class InstallModulesTask
extends Task {
    private String targetDir;
    private FileSet fileset;

    public void execute() throws BuildException {
        try {
            DirectoryScanner dsc = this.fileset.getDirectoryScanner(this.getProject());
            File baseDir = dsc.getBasedir();
            String[] files = dsc.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String currentFile = files[i];
                File moduleXml = new File(baseDir, currentFile);
                String modulePath = currentFile.substring(0, currentFile.lastIndexOf(File.separator));
                File libDir = new File(this.targetDir, modulePath);
                File destFile = new File(this.targetDir, currentFile);
                System.out.println("Processing descriptor for module " + modulePath);
                System.out.println("* Source module descriptor: " + moduleXml);
                System.out.println("* Destination module descriptor: " + destFile);
                String c = InstallModulesTask.readFileContents(moduleXml);
                if (libDir.exists()) {
                    String[] libs = libDir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".sar") || name.endsWith(".war");
                        }
                    });
                    BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
                    out.write(InstallModulesTask.updateContents(c, libs));
                    out.close();
                    continue;
                }
                libDir.mkdirs();
                BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
                out.write(c);
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContents(File file) throws Exception {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    private static String updateContents(String contents, String[] libs) {
        StringBuilder sb = new StringBuilder();
        for (String f : libs) {
            sb.append("<resource-root path=\"");
            sb.append(f);
            sb.append("\"/>\n        ");
        }
        return contents.replaceFirst("<!-- Insert resources here -->", sb.toString());
    }

    public FileSet createFileset() {
        this.fileset = new FileSet();
        return this.fileset;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }
}

