/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.trycatch;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.trycatch.TryCatchFinallyControlFlow;

public class CatchHandler
extends CommandHandlerWithHelp {
    public CatchHandler() {
        super("catch", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        TryCatchFinallyControlFlow flow = TryCatchFinallyControlFlow.get(ctx);
        return flow != null && flow.isInTry();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        TryCatchFinallyControlFlow flow = TryCatchFinallyControlFlow.get(ctx);
        if (flow == null) {
            throw new CommandLineException("catch is available only in try-catch-finally control flow");
        }
        if (!flow.isInTry()) {
            throw new CommandLineException("catch may appear only once after try and before finally");
        }
        flow.moveToCatch();
    }
}

