/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.ejb.client.AbstractReceiverInvocationContext;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.wildfly.common.Assert;
import org.wildfly.discovery.Discovery;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBReceiverInvocationContext
extends AbstractReceiverInvocationContext {
    private final EJBClientInvocationContext clientInvocationContext;

    EJBReceiverInvocationContext(EJBClientInvocationContext clientInvocationContext) {
        this.clientInvocationContext = clientInvocationContext;
    }

    public void proceedAsynchronously() {
        this.clientInvocationContext.proceedAsynchronously();
    }

    public void resultReady(ResultProducer resultProducer) {
        this.clientInvocationContext.resultReady(resultProducer);
    }

    public void requestCancelled() {
        this.clientInvocationContext.cancelled();
    }

    public void requestFailed(Exception cause) {
        this.requestFailed(cause, Runnable::run);
    }

    public void requestFailed(Exception cause, Executor retryExecutor) {
        Assert.checkNotNullParam((String)"cause", (Object)cause);
        Assert.checkNotNullParam((String)"retryExecutor", (Object)retryExecutor);
        this.clientInvocationContext.failed(cause, retryExecutor);
    }

    @Override
    public EJBClientInvocationContext getClientInvocationContext() {
        return this.clientInvocationContext;
    }

    public EJBClientContext getClientContext() {
        return this.clientInvocationContext.getClientContext();
    }

    public Discovery getDiscovery() {
        return this.clientInvocationContext.getDiscovery();
    }

    @Override
    public AuthenticationContext getAuthenticationContext() {
        return this.clientInvocationContext.getAuthenticationContext();
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(EJBReceiverInvocationContext.class.getName() + "@" + System.identityHashCode(this));
        if (this.getClientInvocationContext() != null) {
            toString.append(" - ").append(this.getClientInvocationContext().getLocator().toString()).append(", method: ").append(this.getClientInvocationContext().getInvokedMethod().getName());
        }
        return toString.toString();
    }

    public static interface ResultProducer {
        public static final ResultProducer NULL = new Immediate(null);

        public Object getResult() throws Exception;

        public void discardResult();

        public static class Immediate
        implements ResultProducer {
            private final Object result;

            public Immediate(Object result) {
                this.result = result;
            }

            @Override
            public Object getResult() throws Exception {
                return this.result;
            }

            @Override
            public void discardResult() {
            }
        }

        public static class Failed
        implements ResultProducer {
            private final Supplier<Exception> cause;

            public Failed(Exception cause) {
                this(() -> {
                    StackTraceElement[] stackTrace = new Throwable().getStackTrace();
                    cause.setStackTrace(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
                    return cause;
                });
                Assert.checkNotNullParam((String)"cause", (Object)cause);
            }

            public Failed(Supplier<Exception> cause) {
                Assert.checkNotNullParam((String)"cause", cause);
                this.cause = cause;
            }

            @Override
            public Object getResult() throws Exception {
                throw this.cause.get();
            }

            public Supplier<Exception> getExceptionSupplier() {
                return this.cause;
            }

            @Override
            public void discardResult() {
            }
        }
    }
}

