/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.sso;

import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.client.InfinispanClientRequirement;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagementConfiguration;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactory;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOManagerFactoryConfiguration;

public class HotRodSSOManagerFactoryServiceConfigurator<A, D, S>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
HotRodSSOManagerFactoryConfiguration {
    private final String name;
    private final HotRodSSOManagementConfiguration config;
    private volatile SupplierDependency<RemoteCacheContainer> container;

    public HotRodSSOManagerFactoryServiceConfigurator(HotRodSSOManagementConfiguration config, String name) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "sso", name}));
        this.name = name;
        this.config = config;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.container = new ServiceSupplierDependency(InfinispanClientRequirement.REMOTE_CONTAINER.getServiceName(support, this.config.getContainerName()));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = this.container.register(builder).provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)factory, new HotRodSSOManagerFactory(this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public <K, V> RemoteCache<K, V> getRemoteCache() {
        return ((RemoteCacheContainer)this.container.get()).administration().getOrCreateCache(this.name, this.config.getConfigurationName());
    }
}

