/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.stream.Stream;
import org.jboss.as.clustering.controller.ResourceServiceNameFactory;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.msc.service.ServiceName;

public enum CacheComponent implements ResourceServiceNameFactory
{
    MODULE("module"),
    EXPIRATION(ExpirationResourceDefinition.PATH),
    LOCKING(LockingResourceDefinition.PATH),
    MEMORY(MemoryResourceDefinition.WILDCARD_PATH),
    PERSISTENCE{

        @Override
        public ServiceName getServiceName(PathAddress cacheAddress) {
            return StoreResourceDefinition.Capability.PERSISTENCE.getServiceName(cacheAddress.append(new PathElement[]{StoreResourceDefinition.WILDCARD_PATH}));
        }
    }
    ,
    STATE_TRANSFER(StateTransferResourceDefinition.PATH),
    PARTITION_HANDLING(PartitionHandlingResourceDefinition.PATH),
    STORE_WRITE(StoreWriteResourceDefinition.WILDCARD_PATH),
    TRANSACTION(TransactionResourceDefinition.PATH),
    BINARY_TABLE(StoreResourceDefinition.WILDCARD_PATH, BinaryTableResourceDefinition.PATH),
    STRING_TABLE(StoreResourceDefinition.WILDCARD_PATH, StringTableResourceDefinition.PATH),
    BACKUPS(BackupResourceDefinition.WILDCARD_PATH);

    private final String[] components;

    private CacheComponent() {
        this(Stream.empty());
    }

    private CacheComponent(PathElement ... paths) {
        this(Stream.of(paths).map(path -> path.isWildcard() ? path.getKey() : path.getValue()));
    }

    private CacheComponent(Stream<String> components) {
        this((String[])components.toArray(String[]::new));
    }

    private CacheComponent(String ... components) {
        this.components = components;
    }

    public ServiceName getServiceName(PathAddress cacheAddress) {
        return CacheResourceDefinition.Capability.CONFIGURATION.getServiceName(cacheAddress).append(this.components);
    }
}

