/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import org.jboss.as.weld.injection.WeldInjectionContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.construction.api.ConstructionHandle;
import org.jboss.weld.construction.api.WeldCreationalContext;

public class WeldConstructionStartInterceptor
implements Interceptor {
    public static final WeldConstructionStartInterceptor INSTANCE = new WeldConstructionStartInterceptor();

    private WeldConstructionStartInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        WeldInjectionContext injectionCtx = (WeldInjectionContext)context.getPrivateData(WeldInjectionContext.class);
        this.setupAroundConstructCallback(injectionCtx.getContext(), context);
        injectionCtx.produce();
        return context.getTarget();
    }

    private <T> void setupAroundConstructCallback(CreationalContext<T> ctx, final InterceptorContext context) {
        WeldCreationalContext ctxImpl = (WeldCreationalContext)ctx;
        ctxImpl.setConstructorInterceptionSuppressed(true);
        ctxImpl.registerAroundConstructCallback(new AroundConstructCallback<T>(){

            public T aroundConstruct(ConstructionHandle<T> ctx, AnnotatedConstructor<T> constructor, Object[] parameters, Map<String, Object> data) throws Exception {
                context.putPrivateData(ConstructionHandle.class, ctx);
                context.setParameters(parameters);
                context.setContextData(data);
                context.setConstructor(constructor.getJavaMember());
                context.proceed();
                return context.getTarget();
            }
        });
    }
}

