/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;

public class Unmarshaller
extends ProcessingContext
implements DeserializationContext {
    private static final Logger logger = Logger.getLogger(Unmarshaller.class.getName());

    public Unmarshaller(JsonbContext jsonbContext) {
        super(jsonbContext);
    }

    public <T> T deserialize(Class<T> clazz, JsonParser parser) {
        return this.deserializeItem(clazz, parser);
    }

    public <T> T deserialize(Type type, JsonParser parser) {
        return this.deserializeItem(type, parser);
    }

    private <T> T deserializeItem(Type type, JsonParser parser) {
        try {
            DeserializerBuilder deserializerBuilder = ((DeserializerBuilder)new DeserializerBuilder(this.jsonbContext).withType(type)).withJsonValueType(this.getRootEvent(parser));
            Class<?> rawType = ReflectionUtils.getRawType(type);
            if (!DefaultSerializers.getInstance().isKnownType(rawType)) {
                ClassModel classModel = this.getMappingContext().getOrCreateClassModel(rawType);
                deserializerBuilder.withCustomization(classModel.getCustomization());
            }
            return (T)deserializerBuilder.build().deserialize(parser, (DeserializationContext)this, type);
        }
        catch (JsonbException e) {
            logger.severe(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, e.getMessage()), (Throwable)e);
        }
    }

    private JsonParser.Event getRootEvent(JsonParser parser) {
        JsonbRiParser.LevelContext currentLevel = ((JsonbParser)parser).getCurrentLevel();
        if (currentLevel.getParent() == null) {
            return parser.next();
        }
        JsonParser.Event lastEvent = currentLevel.getLastEvent();
        return lastEvent == JsonParser.Event.KEY_NAME ? parser.next() : lastEvent;
    }
}

