/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal.logging;

import io.agroal.api.AgroalDataSourceListener;
import java.sql.Connection;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;

public class LoggingDataSourceListener
implements AgroalDataSourceListener {
    private final String datasourceName;

    public LoggingDataSourceListener(String name) {
        this.datasourceName = name;
    }

    public void beforeConnectionLeak(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Leak test on connection {1}", this.datasourceName, connection);
    }

    public void beforeConnectionReap(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Reap test on connection {1}", this.datasourceName, connection);
    }

    public void beforeConnectionValidation(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Validation test on connection {1}", this.datasourceName, connection);
    }

    public void onConnectionAcquire(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Acquire connection {1}", this.datasourceName, connection);
    }

    public void onConnectionCreation(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Created connection {1}", this.datasourceName, connection);
    }

    public void onConnectionReap(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Closing idle connection {1}", this.datasourceName, connection);
    }

    public void onConnectionReturn(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Returning connection {1}", this.datasourceName, connection);
    }

    public void onConnectionDestroy(Connection connection) {
        AgroalLogger.POOL_LOGGER.debugv("{0}: Destroyed connection {1}", this.datasourceName, connection);
    }

    public void onWarning(String warning) {
        AgroalLogger.POOL_LOGGER.poolWarning(this.datasourceName, warning);
    }

    public void onWarning(Throwable throwable) {
        AgroalLogger.POOL_LOGGER.poolWarning(this.datasourceName, throwable.getMessage());
        AgroalLogger.POOL_LOGGER.debug("Cause: ", throwable);
    }
}

