/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class AspectDeploymentProcessor
implements DeploymentUnitProcessor {
    private Class<? extends DeploymentAspect> clazz;
    private String aspectClass;
    private DeploymentAspect aspect;

    public AspectDeploymentProcessor(Class<? extends DeploymentAspect> aspectClass) {
        this.clazz = aspectClass;
    }

    public AspectDeploymentProcessor(String aspectClass) {
        this.aspectClass = aspectClass;
    }

    public AspectDeploymentProcessor(DeploymentAspect aspect) {
        this.aspect = aspect;
        this.clazz = aspect.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (AspectDeploymentProcessor.isWebServiceDeployment(unit)) {
            this.ensureAspectInitialized();
            Deployment dep = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.DEPLOYMENT_KEY);
            WSLogger.ROOT_LOGGER.tracef("%s start: %s", this.aspect, unit.getName());
            ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.aspect.getLoader());
                dep.addAttachment(ServiceTarget.class, (Object)phaseContext.getServiceTarget());
                this.aspect.start(dep);
                dep.removeAttachment(ServiceTarget.class);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit unit) {
        if (AspectDeploymentProcessor.isWebServiceDeployment(unit)) {
            Deployment dep = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.DEPLOYMENT_KEY);
            WSLogger.ROOT_LOGGER.tracef("%s stop: %s", this.aspect, unit.getName());
            ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.aspect.getLoader());
                this.aspect.stop(dep);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
            }
        }
    }

    private void ensureAspectInitialized() throws DeploymentUnitProcessingException {
        if (this.aspect == null) {
            try {
                if (this.clazz == null) {
                    this.clazz = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader().loadClass(this.aspectClass);
                }
                this.aspect = this.clazz.newInstance();
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
    }

    private static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY) != null;
    }
}

