/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.NameCache;
import org.jgroups.util.SocketFactory;

@Deprecated
@MBean(description="Channel")
public class Channel
implements Closeable {
    protected final JChannel ch;

    public Channel(JChannel ch) {
        this.ch = ch;
    }

    @ManagedAttribute(description="The current state")
    public String getState() {
        return this.ch.getState();
    }

    public ProtocolStack getProtocolStack() {
        return this.ch.getProtocolStack();
    }

    public SocketFactory getSocketFactory() {
        return ((Protocol)this.ch.getProtocolStack().getBottomProtocol()).getSocketFactory();
    }

    public void setSocketFactory(SocketFactory factory) {
        Protocol prot;
        ProtocolStack stack = this.getProtocolStack();
        Protocol protocol = prot = stack != null ? stack.getTopProtocol() : null;
        if (prot != null) {
            prot.setSocketFactory(factory);
        }
    }

    public void connect(String cluster_name) throws Exception {
        this.ch.connect(cluster_name);
    }

    public void connect(String cluster_name, Address target, long timeout) throws Exception {
        this.ch.connect(cluster_name, target, timeout);
    }

    public void disconnect() {
        this.ch.disconnect();
    }

    @Override
    public void close() {
        this.ch.close();
    }

    @ManagedAttribute
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @ManagedAttribute
    public boolean isConnected() {
        return this.ch.isConnected();
    }

    @ManagedAttribute
    public boolean isConnecting() {
        return this.ch.isConnecting();
    }

    @ManagedAttribute
    public boolean isClosed() {
        return this.ch.isClosed();
    }

    public Map<String, Map<String, Object>> dumpStats() {
        return this.ch.dumpStats();
    }

    public void send(Message msg) throws Exception {
        this.ch.send(msg);
    }

    public void send(Address dst, Object obj) throws Exception {
        this.ch.send(dst, obj);
    }

    public void send(Address dst, byte[] buf) throws Exception {
        this.ch.send(dst, buf);
    }

    public void send(Address dst, byte[] buf, int offset, int length) throws Exception {
        this.ch.send(dst, buf, offset, length);
    }

    public Object down(Event evt) {
        if (evt.type() == 1) {
            return this.ch.down((Message)evt.getArg());
        }
        return this.ch.down(evt);
    }

    public View getView() {
        return this.ch.getView();
    }

    public Address getAddress() {
        return this.ch.getAddress();
    }

    public String getName() {
        return this.ch.getName();
    }

    public String getName(Address member) {
        return member != null ? NameCache.get(member) : null;
    }

    public void setName(String name) {
        this.ch.setName(name);
    }

    public Channel name(String name) {
        this.ch.name(name);
        return this;
    }

    public String getClusterName() {
        return this.ch.getClusterName();
    }

    public String getProperties() {
        return this.ch.getProtocolStack() != null ? this.ch.getProtocolStack().printProtocolSpec(true) : null;
    }

    public void setUpHandler(UpHandler up_handler) {
        this.ch.setUpHandler(up_handler);
    }

    public UpHandler getUpHandler() {
        return this.ch.getUpHandler();
    }

    public synchronized void addChannelListener(ChannelListener listener) {
        this.ch.addChannelListener(listener);
    }

    public synchronized void removeChannelListener(ChannelListener listener) {
        this.ch.removeChannelListener(listener);
    }

    public synchronized void clearChannelListeners() {
        this.ch.clearChannelListeners();
    }

    public void setReceiver(Receiver r) {
        this.ch.setReceiver(r);
    }

    public Receiver getReceiver() {
        return this.ch.getReceiver();
    }

    public void setDiscardOwnMessages(boolean flag) {
        this.ch.setDiscardOwnMessages(flag);
    }

    public boolean getDiscardOwnMessages() {
        return this.ch.getDiscardOwnMessages();
    }

    public boolean flushSupported() {
        return this.ch.flushSupported();
    }

    public void startFlush(List<Address> flushParticipants, boolean automatic_resume) throws Exception {
        this.ch.startFlush(flushParticipants, automatic_resume);
    }

    public void startFlush(boolean automatic_resume) throws Exception {
        this.ch.startFlush(automatic_resume);
    }

    public void stopFlush() {
        this.ch.stopFlush();
    }

    public void stopFlush(List<Address> flushParticipants) {
        this.ch.stopFlush(flushParticipants);
    }

    public void getState(Address target, long timeout) throws Exception {
        this.ch.getState(target, timeout);
    }

    public static enum State {
        OPEN,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }
}

