/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class SessionObjectReferenceImpl
implements SessionObjectReference {
    private final Map<Class<?>, ServiceName> viewServices;
    private final String ejbName;
    private transient Map<String, ManagedReference> businessInterfaceToReference;

    public SessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.ejbName = descriptor.getEjbName();
        this.viewServices = descriptor.getViewServices();
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        String businessInterfaceName = businessInterfaceType.getName();
        ManagedReference managedReference = null;
        if (this.businessInterfaceToReference == null) {
            this.businessInterfaceToReference = new HashMap<String, ManagedReference>();
        } else {
            managedReference = this.businessInterfaceToReference.get(businessInterfaceName);
        }
        if (managedReference == null) {
            if (this.viewServices.containsKey(businessInterfaceType)) {
                ServiceController serviceController = SessionObjectReferenceImpl.currentServiceContainer().getRequiredService(this.viewServices.get(businessInterfaceType));
                ComponentView view = (ComponentView)serviceController.getValue();
                try {
                    managedReference = view.createInstance();
                    this.businessInterfaceToReference.put(businessInterfaceType.getName(), managedReference);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw WeldLogger.ROOT_LOGGER.viewNotFoundOnEJB(businessInterfaceType.getName(), this.ejbName);
            }
        }
        return (S)managedReference.getInstance();
    }

    public void remove() {
    }

    public boolean isRemoved() {
        return false;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

