/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class IdentityServiceConfigurator<T>
extends SimpleServiceNameProvider
implements ServiceConfigurator {
    private final ServiceName requirementName;
    private final ServiceController.Mode initialMode;

    public IdentityServiceConfigurator(ServiceName name, ServiceName requirementName) {
        this(name, requirementName, ServiceController.Mode.PASSIVE);
    }

    public IdentityServiceConfigurator(ServiceName name, ServiceName requirementName, ServiceController.Mode initialMode) {
        super(name);
        assert (initialMode != ServiceController.Mode.REMOVE);
        this.requirementName = requirementName;
        this.initialMode = initialMode;
    }

    @Override
    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer injector = builder.provides(new ServiceName[]{this.getServiceName()});
        Supplier requirement = builder.requires(this.requirementName);
        FunctionalService service = new FunctionalService(injector, Function.identity(), requirement);
        return builder.setInstance(service).setInitialMode(this.initialMode);
    }
}

