/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldMetadataCreationContext;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class FieldMetadataBuilderImpl
implements FieldMetadataBuilder {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final Set<String> sortableFieldsAbsoluteNames = new LinkedHashSet<String>();
    private final Set<BridgeDefinedField> bridgeDefinedFields = new LinkedHashSet<BridgeDefinedField>();
    private final BackReference<DocumentFieldMetadata> fieldMetadata;

    public FieldMetadataBuilderImpl(BackReference<DocumentFieldMetadata> fieldMetadata) {
        this.fieldMetadata = fieldMetadata;
    }

    @Override
    public FieldMetadataCreationContext field(String name, FieldType type) {
        return new FieldMetadataCreationContextImpl(name, type);
    }

    public Set<String> getSortableFieldsAbsoluteNames() {
        return this.sortableFieldsAbsoluteNames;
    }

    public Set<BridgeDefinedField> getBridgeDefinedFields() {
        return this.bridgeDefinedFields;
    }

    private class FieldMetadataCreationContextImpl
    implements FieldMetadataCreationContext {
        private final BridgeDefinedField field;

        public FieldMetadataCreationContextImpl(String name, FieldType type) {
            this.field = new BridgeDefinedField(FieldMetadataBuilderImpl.this.fieldMetadata, name, type);
            FieldMetadataBuilderImpl.this.bridgeDefinedFields.add(this.field);
        }

        @Override
        public FieldMetadataCreationContext field(String name, FieldType type) {
            return FieldMetadataBuilderImpl.this.field(name, type);
        }

        @Override
        public FieldMetadataCreationContext sortable(boolean sortable) {
            FieldMetadataBuilderImpl.this.sortableFieldsAbsoluteNames.add(this.field.getAbsoluteName());
            return this;
        }

        @Override
        public <T extends FieldMetadataCreationContext> T mappedOn(Class<T> backend) {
            return this.create(backend);
        }

        private <T extends FieldMetadataCreationContext> T create(Class<T> backend) {
            try {
                return (T)((FieldMetadataCreationContext)backend.getDeclaredConstructor(BridgeDefinedField.class, FieldMetadataCreationContext.class).newInstance(this.field, this));
            }
            catch (Exception e) {
                throw LOG.cannotCreateBridgeDefinedField(backend, e);
            }
        }
    }
}

