/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class NumericFieldsConfiguration {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final IndexedTypeIdentifier indexedType;
    private final String propertyName;
    private final Map<String, NumericField> fieldsMarkedAsNumeric;
    private final Set<String> fieldsOfProperty = new LinkedHashSet<String>();

    NumericFieldsConfiguration(IndexedTypeIdentifier indexedTypeIdentifier, String propertyName, Map<String, NumericField> fieldsMarkedAsNumeric) {
        this.indexedType = indexedTypeIdentifier;
        this.propertyName = propertyName;
        this.fieldsMarkedAsNumeric = fieldsMarkedAsNumeric;
    }

    NumericField getNumericFieldAnnotation(DocumentFieldPath path) {
        this.fieldsOfProperty.add(path.getRelativeName());
        NumericField numericFieldAnnotation = this.fieldsMarkedAsNumeric.get(path.getRelativeName());
        if (numericFieldAnnotation == null) {
            numericFieldAnnotation = this.fieldsMarkedAsNumeric.get("");
        }
        return numericFieldAnnotation;
    }

    boolean isNumericField(DocumentFieldPath path) {
        return this.getNumericFieldAnnotation(path) != null;
    }

    void validate() {
        for (String fieldMarkedAsNumeric : this.fieldsMarkedAsNumeric.keySet()) {
            if (this.fieldsOfProperty.contains(fieldMarkedAsNumeric) || fieldMarkedAsNumeric.isEmpty() && !this.fieldsOfProperty.isEmpty()) continue;
            throw LOG.numericFieldAnnotationWithoutMatchingField(this.indexedType, this.propertyName);
        }
    }
}

