/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.spi.DirectoryHelper;
import org.hibernate.search.store.spi.LockFactoryCreator;

public class RAMDirectoryProvider
implements DirectoryProvider<RAMDirectory> {
    private RAMDirectory directory;
    private String indexName;
    private Properties properties;
    private ServiceManager serviceManager;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.indexName = directoryProviderName;
        this.properties = properties;
        this.serviceManager = context.getServiceManager();
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
        try {
            LockFactory lockFactory = this.serviceManager.requestService(LockFactoryCreator.class).createLockFactory(null, this.properties);
            this.directory = this.makeRAMDirectory(lockFactory);
            this.properties = null;
            DirectoryHelper.initializeIndexIfNeeded((Directory)this.directory);
        }
        finally {
            this.serviceManager.releaseService(LockFactoryCreator.class);
        }
    }

    @Override
    public RAMDirectory getDirectory() {
        return this.directory;
    }

    @Override
    public void stop() {
        this.directory.close();
    }

    protected RAMDirectory makeRAMDirectory(LockFactory lockFactory) {
        return new RAMDirectory(lockFactory);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RAMDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((RAMDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 7;
        return 29 * hash + this.indexName.hashCode();
    }
}

