/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.cluster.SecurityActions;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterListenerReplicateCallable<K, V>
implements DistributedCallable<K, V, Void> {
    private static final Log log = LogFactory.getLog(ClusterListenerReplicateCallable.class);
    private static final boolean trace = log.isTraceEnabled();
    private transient EmbeddedCacheManager cacheManager;
    private transient CacheNotifier cacheNotifier;
    private transient CacheManagerNotifier cacheManagerNotifier;
    private transient DistributedExecutorService distExecutor;
    private transient Address ourAddress;
    private transient ClusterEventManager<K, V> eventManager;
    private final UUID identifier;
    private final CacheEventFilter<K, V> filter;
    private final CacheEventConverter<K, V, ?> converter;
    private final Address origin;
    private final boolean sync;
    private final Set<Class<? extends Annotation>> filterAnnotations;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final boolean useStorageFormat;

    public ClusterListenerReplicateCallable(UUID identifier, Address origin, CacheEventFilter<K, V> filter, CacheEventConverter<K, V, ?> converter, boolean sync, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
        this.identifier = identifier;
        this.origin = origin;
        this.filter = filter;
        this.converter = converter;
        this.sync = sync;
        this.filterAnnotations = filterAnnotations;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.useStorageFormat = useStorageFormat;
        if (trace) {
            log.tracef("Created clustered listener replicate callable for: %s", filterAnnotations);
        }
    }

    @Override
    public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
        this.cacheManager = cache.getCacheManager();
        ComponentRegistry componentRegistry = SecurityActions.getComponentRegistry(cache.getAdvancedCache());
        this.cacheNotifier = componentRegistry.getComponent(CacheNotifier.class);
        this.cacheManagerNotifier = componentRegistry.getComponent(CacheManagerNotifier.class);
        this.distExecutor = SecurityActions.getDefaultExecutorService(cache);
        this.ourAddress = cache.getCacheManager().getAddress();
        this.eventManager = componentRegistry.getComponent(ClusterEventManager.class);
        if (this.filter != null) {
            componentRegistry.wireDependencies(this.filter);
        }
        if (this.converter != null && this.converter != this.filter) {
            componentRegistry.wireDependencies(this.converter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        if (!this.ourAddress.equals(this.origin)) {
            if (this.cacheManager.getMembers().contains(this.origin)) {
                CacheNotifier cacheNotifier = this.cacheNotifier;
                synchronized (cacheNotifier) {
                    boolean alreadyInstalled = false;
                    for (Object installedListener : this.cacheNotifier.getListeners()) {
                        if (!(installedListener instanceof RemoteClusterListener) || !this.identifier.equals(((RemoteClusterListener)installedListener).getId())) continue;
                        alreadyInstalled = true;
                        break;
                    }
                    if (!alreadyInstalled) {
                        RemoteClusterListener listener = new RemoteClusterListener(this.identifier, this.origin, this.distExecutor, this.cacheNotifier, this.cacheManagerNotifier, this.eventManager, this.sync);
                        ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, this.useStorageFormat);
                        this.cacheNotifier.addFilteredListener(listenerHolder, this.filter, this.converter, this.filterAnnotations);
                        this.cacheManagerNotifier.addListener(listener);
                        if (!this.cacheManager.getMembers().contains(this.origin)) {
                            this.cacheNotifier.removeListener(listener);
                            this.cacheManagerNotifier.removeListener(listener);
                            if (trace) {
                                log.tracef("Removing local cluster listener for remote cluster listener that was just registered, as the origin %s went away concurrently", this.origin);
                            }
                        } else if (trace) {
                            log.tracef("Registered local cluster listener for remote cluster listener from origin %s with id %s", this.origin, this.identifier);
                        }
                    } else if (trace) {
                        log.tracef("Local cluster listener from origin %s with id %s was already installed, ignoring", this.origin, this.identifier);
                    }
                }
            } else if (trace) {
                log.tracef("Not registering local cluster listener for remote cluster listener from origin %s, as the origin went away", this.origin);
            }
        } else if (trace) {
            log.trace("Not registering local cluster listener as we are the node who registered the cluster listener");
        }
        return null;
    }

    public static class Externalizer
    extends AbstractExternalizer<ClusterListenerReplicateCallable> {
        public Set<Class<? extends ClusterListenerReplicateCallable>> getTypeClasses() {
            return Collections.singleton(ClusterListenerReplicateCallable.class);
        }

        public void writeObject(ObjectOutput output, ClusterListenerReplicateCallable object) throws IOException {
            output.writeObject(object.identifier);
            output.writeObject(object.origin);
            output.writeObject(object.filter);
            if (object.filter == object.converter && object.filter instanceof CacheEventFilterConverter) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                output.writeObject(object.converter);
            }
            output.writeBoolean(object.sync);
            MarshallUtil.marshallCollection((Collection)object.filterAnnotations, (ObjectOutput)output);
            DataConversion.writeTo(output, object.keyDataConversion);
            DataConversion.writeTo(output, object.valueDataConversion);
            output.writeBoolean(object.useStorageFormat);
        }

        public ClusterListenerReplicateCallable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            UUID id = (UUID)input.readObject();
            Address address = (Address)input.readObject();
            CacheEventFilter filter = (CacheEventFilter)input.readObject();
            boolean sameConverter = input.readBoolean();
            CacheEventConverter converter = sameConverter ? (CacheEventFilterConverter)filter : (CacheEventConverter)input.readObject();
            boolean sync = input.readBoolean();
            Set listenerAnnots = (Set)MarshallUtil.unmarshallCollection((ObjectInput)input, HashSet::new);
            DataConversion keyDataConversion = DataConversion.readFrom(input);
            DataConversion valueDataConversion = DataConversion.readFrom(input);
            boolean raw = input.readBoolean();
            return new ClusterListenerReplicateCallable(id, address, filter, converter, sync, listenerAnnots, keyDataConversion, valueDataConversion, raw);
        }

        public Integer getId() {
            return 68;
        }
    }
}

