/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.security.idm.Account;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.core.DefaultAuthorizationManager;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.servlet.http.HttpServletRequest;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

class ElytronAuthorizationManager
implements AuthorizationManager {
    private final SecurityDomain securityDomain;

    ElytronAuthorizationManager(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isUserInRole(String roleName, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        return DefaultAuthorizationManager.INSTANCE.isUserInRole(roleName, account, servletInfo, request, deployment);
    }

    public boolean canAccessResource(List<SingleConstraintMatch> mappedConstraints, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
        if (DefaultAuthorizationManager.INSTANCE.canAccessResource(mappedConstraints, account, servletInfo, request, deployment)) {
            return true;
        }
        SecurityIdentity securityIdentity = this.securityDomain.getCurrentSecurityIdentity();
        if (securityIdentity == null) {
            return false;
        }
        ArrayList<Object> permissions = new ArrayList<Object>();
        permissions.add(new WebResourcePermission(this.getCanonicalURI(request), request.getMethod()));
        for (String string : securityIdentity.getRoles("web", true)) {
            permissions.add(new WebRoleRefPermission(this.getCanonicalURI(request), string));
        }
        for (Permission permission : permissions) {
            if (!securityIdentity.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public TransportGuaranteeType transportGuarantee(TransportGuaranteeType currentConnectionGuarantee, TransportGuaranteeType configuredRequiredGuarantee, HttpServletRequest request) {
        return DefaultAuthorizationManager.INSTANCE.transportGuarantee(currentConnectionGuarantee, configuredRequiredGuarantee, request);
    }

    private String getCanonicalURI(HttpServletRequest request) {
        String canonicalURI = request.getRequestURI().substring(request.getContextPath().length());
        if (canonicalURI == null || canonicalURI.equals("/")) {
            canonicalURI = "";
        }
        return canonicalURI;
    }
}

