/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Util;

public class AuthenticationConfiguration {
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false, Boolean.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> USERNAME = AttributeDefinition.builder((String)"username", null, String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> PASSWORD = AttributeDefinition.builder((String)"password", null, String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> REALM = AttributeDefinition.builder((String)"realm", null, String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<CallbackHandler> CALLBACK_HANDLER = AttributeDefinition.builder((String)"callback-handler", null, CallbackHandler.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<Subject> CLIENT_SUBJECT = AttributeDefinition.builder((String)"client-subject", null, Subject.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SASL_MECHANISM = AttributeDefinition.builder((String)"sasl-mechanism", null, String.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SERVER_NAME = AttributeDefinition.builder((String)"server-name", null, String.class).immutable().build();
    static final AttributeDefinition<Map> SASL_PROPERTIES = AttributeDefinition.builder((String)"sasl-properties", null, Map.class).initializer(() -> new HashMap()).autoPersist(false).immutable().build();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{ENABLED, USERNAME, PASSWORD, REALM, CALLBACK_HANDLER, CLIENT_SUBJECT, SASL_MECHANISM, SERVER_NAME, SASL_PROPERTIES});
    }

    public AuthenticationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public CallbackHandler callbackHandler() {
        return (CallbackHandler)this.attributes.attribute(CALLBACK_HANDLER).get();
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public String username() {
        return (String)this.attributes.attribute(USERNAME).get();
    }

    public char[] password() {
        return Util.toCharArray((String)((String)this.attributes.attribute(PASSWORD).get()));
    }

    public String realm() {
        return (String)this.attributes.attribute(REALM).get();
    }

    public String saslMechanism() {
        return (String)this.attributes.attribute(SASL_MECHANISM).get();
    }

    public Map<String, String> saslProperties() {
        return (Map)this.attributes.attribute(SASL_PROPERTIES).get();
    }

    public String serverName() {
        return (String)this.attributes.attribute(SERVER_NAME).get();
    }

    public Subject clientSubject() {
        return (Subject)this.attributes.attribute(CLIENT_SUBJECT).get();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public boolean equals(Object o) {
        AuthenticationConfiguration other = (AuthenticationConfiguration)o;
        return this.attributes.equals((Object)other.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }
}

