/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.net;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class InetSocketAddressExternalizer
implements Externalizer<InetSocketAddress> {
    public void writeObject(ObjectOutput output, InetSocketAddress socketAddress) throws IOException {
        InetAddress address = socketAddress.getAddress();
        DefaultExternalizer.INET_ADDRESS.writeObject(output, address);
        IndexSerializer.UNSIGNED_SHORT.writeInt(output, socketAddress.getPort());
        if (address == null) {
            output.writeUTF(socketAddress.getHostName());
        }
    }

    public InetSocketAddress readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        InetAddress address = (InetAddress)DefaultExternalizer.INET_ADDRESS.cast(InetAddress.class).readObject(input);
        int port = IndexSerializer.UNSIGNED_SHORT.readInt(input);
        return address != null ? new InetSocketAddress(address, port) : InetSocketAddress.createUnresolved(input.readUTF(), port);
    }

    public Class<InetSocketAddress> getTargetClass() {
        return InetSocketAddress.class;
    }
}

