/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.cache.AbstractIdentityCache;

@ManagedResource
public class MemoryIdentityCache
extends AbstractIdentityCache {
    private static final Logger LOG = LogUtils.getL7dLogger(MemoryIdentityCache.class);
    private final Map<String, Map<String, String>> cache = Collections.synchronizedMap(new HashMap());
    private long maxCacheItems = 10000L;

    protected MemoryIdentityCache() {
        super(null, null);
    }

    public MemoryIdentityCache(IdentityMapper identityMapper) {
        super(null, identityMapper);
    }

    public MemoryIdentityCache(Bus bus, IdentityMapper identityMapper) {
        super(bus, identityMapper);
        InstrumentationManager im;
        if (bus != null && (im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class)) != null) {
            try {
                im.register((ManagedComponent)this);
            }
            catch (JMException e) {
                LOG.log(Level.WARNING, "Registering MemoryIdentityCache failed.", e);
            }
        }
    }

    public long getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public void setMaxCacheItems(long maxCacheItems) {
        this.maxCacheItems = maxCacheItems;
    }

    @Override
    public void add(String user, String realm, Map<String, String> identities) {
        if ((long)this.cache.size() >= this.maxCacheItems) {
            this.cache.clear();
        }
        this.cache.put(user + "@" + realm, identities);
    }

    @Override
    @ManagedOperation
    public Map<String, String> get(String user, String realm) {
        return this.cache.get(user + "@" + realm);
    }

    @Override
    public void remove(String user, String realm) {
        this.cache.remove(user + "@" + realm);
    }

    @Override
    @ManagedOperation
    public void clear() {
        this.cache.clear();
    }

    @Override
    @ManagedOperation
    public int size() {
        return this.cache.size();
    }

    @ManagedOperation
    public String getContent() {
        return this.cache.toString();
    }

    public ObjectName getObjectName() throws JMException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("org.apache.cxf").append(':');
        if (super.getBus() != null) {
            buffer.append("bus.id").append('=').append(super.getBus().getId()).append(',');
        }
        buffer.append("type").append('=').append("MemoryIdentityCache").append(',');
        buffer.append("name").append('=').append("MemoryIdentityCache-").append(System.identityHashCode(this));
        return new ObjectName(buffer.toString());
    }
}

