/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.XML;

public class RequiredConfigPropertyImpl
implements RequiredConfigProperty {
    private static final long serialVersionUID = 4299927051352998447L;
    private List<LocalizedXsdString> description;
    private XsdString configPropertyName;
    private String id;

    public RequiredConfigPropertyImpl(List<LocalizedXsdString> description, XsdString configPropertyName, String id) {
        if (description != null) {
            this.description = new ArrayList<LocalizedXsdString>(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(XML.RequiredConfigPropertyTag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList<LocalizedXsdString>(0);
        }
        this.configPropertyName = configPropertyName;
        if (!XsdString.isNull((XsdString)this.configPropertyName)) {
            this.configPropertyName.setTag(XML.RequiredConfigPropertyTag.CONFIG_PROPERTY_NAME.toString());
        }
        this.id = id;
    }

    public List<LocalizedXsdString> getDescriptions() {
        return Collections.unmodifiableList(this.description);
    }

    public XsdString getConfigPropertyName() {
        return this.configPropertyName;
    }

    public String getId() {
        return this.id;
    }

    public CopyableMetaData copy() {
        return new RequiredConfigPropertyImpl(CopyUtil.cloneList(this.description), (XsdString)CopyUtil.clone((CopyableMetaData)this.configPropertyName), CopyUtil.cloneString((String)this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configPropertyName == null ? 0 : this.configPropertyName.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequiredConfigPropertyImpl)) {
            return false;
        }
        RequiredConfigPropertyImpl other = (RequiredConfigPropertyImpl)obj;
        if (this.configPropertyName == null ? other.configPropertyName != null : !this.configPropertyName.equals((Object)other.configPropertyName)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<required-config-property");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        for (LocalizedXsdString d : this.description) {
            sb.append(d);
        }
        if (!XsdString.isNull((XsdString)this.configPropertyName)) {
            sb.append(this.configPropertyName);
        }
        sb.append("</required-config-property>");
        return sb.toString();
    }
}

