/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyManyCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 56;
    private Collection<?> keys;
    private Consumer<EntryView.WriteEntryView<K, V>> f;

    public WriteOnlyManyCommand(Collection<?> keys, Consumer<EntryView.WriteEntryView<K, V>> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.keys = keys;
        this.f = f;
        this.init(componentRegistry);
    }

    public WriteOnlyManyCommand(WriteOnlyManyCommand<K, V> command) {
        super(command);
        this.keys = command.keys;
        this.f = command.f;
        this.keyDataConversion = command.keyDataConversion;
        this.valueDataConversion = command.valueDataConversion;
    }

    public WriteOnlyManyCommand() {
    }

    public Consumer<EntryView.WriteEntryView<K, V>> getConsumer() {
        return this.f;
    }

    public void setKeys(Collection<?> keys) {
        this.keys = keys;
    }

    public final WriteOnlyManyCommand<K, V> withKeys(Collection<?> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 56;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keys = MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, ArrayList::new);
        this.f = (Consumer)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Object k : this.keys) {
            CacheEntry cacheEntry = ctx.lookupEntry(k);
            if (cacheEntry == null) {
                throw new IllegalStateException();
            }
            this.f.accept(EntryViews.writeOnly(cacheEntry, this.valueDataConversion));
        }
        return null;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.keys;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOnlyManyCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.keys;
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.Write<K, V>(this.keyDataConversion, this.valueDataConversion, this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }
}

