/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.globalstate.impl.SecurityActions;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VolatileLocalConfigurationStorage
implements LocalConfigurationStorage {
    protected static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected EmbeddedCacheManager cacheManager;
    protected ParserRegistry parserRegistry;
    protected ConfigurationManager configurationManager;

    @Override
    public void initialize(EmbeddedCacheManager cacheManager) {
        this.configurationManager = SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(ConfigurationManager.class);
        this.cacheManager = cacheManager;
        this.parserRegistry = new ParserRegistry();
    }

    @Override
    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (flags.contains(CacheContainerAdmin.AdminFlag.PERMANENT)) {
            throw log.globalStateDisabled();
        }
    }

    @Override
    public void createCache(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = SecurityActions.getCacheConfiguration(this.cacheManager, name);
        if (existing == null) {
            SecurityActions.defineConfiguration(this.cacheManager, name, configuration);
            log.debugf("Defined cache '%s' on '%s' using %s", name, this.cacheManager.getAddress(), configuration);
        } else {
            if (!existing.matches(configuration)) {
                throw log.incompatibleClusterConfiguration(name, configuration, existing);
            }
            log.debugf("%s already has a cache %s with configuration %s", this.cacheManager.getAddress(), name, configuration);
        }
        SecurityActions.getCache(this.cacheManager, name);
    }

    @Override
    public void removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        log.debugf("Remove cache %s", name);
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry(this.cacheManager);
        ComponentRegistry cacheComponentRegistry = globalComponentRegistry.getNamedComponentRegistry(name);
        if (cacheComponentRegistry != null) {
            cacheComponentRegistry.getComponent(PersistenceManager.class).setClearOnStop(true);
            cacheComponentRegistry.getComponent(CacheJmxRegistration.class).setUnregisterCacheMBean(true);
            cacheComponentRegistry.getComponent(PassivationManager.class).skipPassivationOnStop(true);
            Cache cache = this.cacheManager.getCache(name, false);
            if (cache != null) {
                cache.stop();
            }
        }
        globalComponentRegistry.removeCache(name);
        globalComponentRegistry.getComponent(ConfigurationManager.class).removeConfiguration(name);
        globalComponentRegistry.getComponent(DependencyGraph.class, "org.infinispan.CacheDependencyGraph").remove(name);
    }

    @Override
    public Map<String, Configuration> loadAll() {
        return Collections.emptyMap();
    }
}

