/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateTransferControlCommand
extends XSiteReplicateCommand {
    public static final int COMMAND_ID = 28;
    private StateTransferControl control;
    private XSiteStateProvider provider;
    private XSiteStateConsumer consumer;
    private XSiteStateTransferManager stateTransferManager;
    private String siteName;
    private boolean statusOk;
    private int topologyId;

    public XSiteStateTransferControlCommand(ByteString cacheName, StateTransferControl control, String siteName) {
        super(cacheName);
        this.control = control;
        this.siteName = siteName;
    }

    public XSiteStateTransferControlCommand(ByteString cacheName) {
        super(cacheName);
    }

    public XSiteStateTransferControlCommand() {
        super(null);
    }

    @Override
    public CompletionStage<Void> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        assert (!preserveOrder);
        return receiver.handleStateTransferControl(this);
    }

    public final void initialize(XSiteStateProvider provider, XSiteStateConsumer consumer, XSiteStateTransferManager stateTransferManager) {
        this.provider = provider;
        this.consumer = consumer;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        switch (this.control) {
            case START_SEND: {
                this.provider.startStateTransfer(this.siteName, this.getOrigin(), this.topologyId);
                break;
            }
            case START_RECEIVE: {
                this.consumer.startStateTransfer(this.siteName);
                break;
            }
            case FINISH_RECEIVE: {
                this.consumer.endStateTransfer(this.siteName);
                break;
            }
            case FINISH_SEND: {
                this.stateTransferManager.notifyStatePushFinished(this.siteName, this.getOrigin(), this.statusOk);
                break;
            }
            case CANCEL_SEND: {
                this.provider.cancelStateTransfer(this.siteName);
                break;
            }
            case RESTART_SEND: {
                this.provider.cancelStateTransfer(this.siteName);
                this.provider.startStateTransfer(this.siteName, this.getOrigin(), this.topologyId);
                break;
            }
            case STATUS_REQUEST: {
                return CompletableFuture.completedFuture(this.stateTransferManager.getStatus());
            }
            case CLEAR_STATUS: {
                this.stateTransferManager.clearStatus();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown control command: " + (Object)((Object)this.control));
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 28;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum((Enum)this.control, (ObjectOutput)output);
        switch (this.control) {
            case START_SEND: 
            case RESTART_SEND: {
                output.writeUTF(this.siteName);
                output.writeInt(this.topologyId);
                return;
            }
            case CANCEL_SEND: {
                output.writeUTF(this.siteName);
                return;
            }
            case FINISH_SEND: {
                output.writeUTF(this.siteName);
                output.writeBoolean(this.statusOk);
                return;
            }
            case START_RECEIVE: 
            case FINISH_RECEIVE: {
                MarshallUtil.marshallString((String)this.siteName, (ObjectOutput)output);
                return;
            }
            case STATUS_REQUEST: 
            case CLEAR_STATUS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown control command: " + (Object)((Object)this.control));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException {
        this.control = Objects.requireNonNull((StateTransferControl)MarshallUtil.unmarshallEnum((ObjectInput)input, x$0 -> StateTransferControl.valueOf(x$0)));
        switch (this.control) {
            case START_SEND: 
            case RESTART_SEND: {
                this.siteName = input.readUTF();
                this.topologyId = input.readInt();
                return;
            }
            case CANCEL_SEND: {
                this.siteName = input.readUTF();
                return;
            }
            case FINISH_SEND: {
                this.siteName = input.readUTF();
                this.statusOk = input.readBoolean();
                return;
            }
            case START_RECEIVE: 
            case FINISH_RECEIVE: {
                this.siteName = MarshallUtil.unmarshallString((ObjectInput)input);
                return;
            }
            case STATUS_REQUEST: 
            case CLEAR_STATUS: {
                return;
            }
        }
        throw new IllegalStateException("Unknown control command: " + (Object)((Object)this.control));
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.control == StateTransferControl.STATUS_REQUEST;
    }

    public void setStatusOk(boolean statusOk) {
        this.statusOk = statusOk;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public XSiteStateTransferControlCommand copyForCache(ByteString cacheName) {
        XSiteStateTransferControlCommand copy = new XSiteStateTransferControlCommand(cacheName);
        copy.control = this.control;
        copy.provider = this.provider;
        copy.consumer = this.consumer;
        copy.stateTransferManager = this.stateTransferManager;
        copy.siteName = this.siteName;
        copy.statusOk = this.statusOk;
        copy.topologyId = this.topologyId;
        copy.setOriginSite(this.getOriginSite());
        copy.setOrigin(this.getOrigin());
        return copy;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferControlCommand{control=" + (Object)((Object)this.control) + ", siteName='" + this.siteName + '\'' + ", statusOk=" + this.statusOk + ", cacheName='" + this.cacheName + '\'' + '}';
    }

    public static enum StateTransferControl {
        START_SEND,
        START_RECEIVE,
        FINISH_SEND,
        FINISH_RECEIVE,
        CANCEL_SEND,
        RESTART_SEND,
        STATUS_REQUEST,
        CLEAR_STATUS;

        private static final StateTransferControl[] CACHED_VALUES;

        private static StateTransferControl valueOf(int index) {
            return CACHED_VALUES[index];
        }

        static {
            CACHED_VALUES = StateTransferControl.values();
        }
    }
}

