/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.elytron;

import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.security.elytron.BasicAddHandler;
import org.jboss.as.security.elytron.BasicResourceDefinition;
import org.jboss.as.security.elytron.BasicService;
import org.jboss.as.security.elytron.Capabilities;
import org.jboss.as.security.elytron.SecurityDomainContextRealm;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.JSSESecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

public class ElytronIntegrationResourceDefinitions {
    public static final SimpleAttributeDefinition LEGACY_JAAS_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("legacy-jaas-config", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF})).build();
    public static final SimpleAttributeDefinition LEGACY_JSSE_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("legacy-jsse-config", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF})).build();
    public static final SimpleAttributeDefinition APPLY_ROLE_MAPPERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("apply-role-mappers", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();

    public static ResourceDefinition getElytronRealmResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LEGACY_JAAS_CONFIG, APPLY_ROLE_MAPPERS};
        BasicAddHandler<SecurityRealm> addHandler = new BasicAddHandler<SecurityRealm>(attributes, new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}){

            @Override
            protected BasicService.ValueSupplier<SecurityRealm> getValueSupplier(ServiceBuilder<SecurityRealm> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String legacyJAASConfig = ElytronIntegrationResourceDefinitions.asStringIfDefined(context, LEGACY_JAAS_CONFIG, model);
                boolean applyRoleMappers = APPLY_ROLE_MAPPERS.resolveModelAttribute(context, model).asBoolean();
                InjectedValue securityDomainContextInjector = new InjectedValue();
                if (legacyJAASConfig != null) {
                    serviceBuilder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{legacyJAASConfig}), SecurityDomainContext.class, (Injector)securityDomainContextInjector);
                }
                return () -> {
                    SecurityDomainContext domainContext = (SecurityDomainContext)securityDomainContextInjector.getValue();
                    return new SecurityDomainContextRealm(domainContext, applyRoleMappers);
                };
            }
        };
        return new BasicResourceDefinition("elytron-realm", addHandler, attributes, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }

    public static ResourceDefinition getElytronKeyStoreResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LEGACY_JSSE_CONFIG};
        BasicAddHandler<KeyStore> addHandler = new BasicAddHandler<KeyStore>(attributes, new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}){

            @Override
            protected BasicService.ValueSupplier<KeyStore> getValueSupplier(ServiceBuilder<KeyStore> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String legacyJSSEConfig = ElytronIntegrationResourceDefinitions.asStringIfDefined(context, LEGACY_JSSE_CONFIG, model);
                InjectedValue securityDomainContextInjector = new InjectedValue();
                if (legacyJSSEConfig != null) {
                    serviceBuilder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{legacyJSSEConfig}), SecurityDomainContext.class, (Injector)securityDomainContextInjector);
                }
                return () -> {
                    SecurityDomainContext domainContext = (SecurityDomainContext)securityDomainContextInjector.getValue();
                    JSSESecurityDomain jsseDomain = domainContext.getJSSE();
                    if (jsseDomain == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateJSSEConfig(legacyJSSEConfig);
                    }
                    KeyStore keyStore = jsseDomain.getKeyStore();
                    if (keyStore == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateComponentInJSSEDomain("KeyStore", legacyJSSEConfig);
                    }
                    return keyStore;
                };
            }
        };
        return new BasicResourceDefinition("elytron-key-store", addHandler, attributes, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    }

    public static ResourceDefinition getElytronTrustStoreResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LEGACY_JSSE_CONFIG};
        BasicAddHandler<KeyStore> addHandler = new BasicAddHandler<KeyStore>(attributes, new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}){

            @Override
            protected BasicService.ValueSupplier<KeyStore> getValueSupplier(ServiceBuilder<KeyStore> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String legacyJSSEConfig = ElytronIntegrationResourceDefinitions.asStringIfDefined(context, LEGACY_JSSE_CONFIG, model);
                InjectedValue securityDomainContextInjector = new InjectedValue();
                if (legacyJSSEConfig != null) {
                    serviceBuilder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{legacyJSSEConfig}), SecurityDomainContext.class, (Injector)securityDomainContextInjector);
                }
                return () -> {
                    SecurityDomainContext domainContext = (SecurityDomainContext)securityDomainContextInjector.getValue();
                    JSSESecurityDomain jsseDomain = domainContext.getJSSE();
                    if (jsseDomain == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateJSSEConfig(legacyJSSEConfig);
                    }
                    KeyStore trustStore = jsseDomain.getTrustStore();
                    if (trustStore == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateComponentInJSSEDomain("TrustStore", legacyJSSEConfig);
                    }
                    return trustStore;
                };
            }
        };
        return new BasicResourceDefinition("elytron-trust-store", addHandler, attributes, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    }

    public static ResourceDefinition getElytronKeyManagersResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LEGACY_JSSE_CONFIG};
        BasicAddHandler<KeyManager> addHandler = new BasicAddHandler<KeyManager>(attributes, new RuntimeCapability[]{Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY}){

            @Override
            protected BasicService.ValueSupplier<KeyManager> getValueSupplier(ServiceBuilder<KeyManager> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String legacyJSSEConfig = ElytronIntegrationResourceDefinitions.asStringIfDefined(context, LEGACY_JSSE_CONFIG, model);
                InjectedValue securityDomainContextInjector = new InjectedValue();
                if (legacyJSSEConfig != null) {
                    serviceBuilder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{legacyJSSEConfig}), SecurityDomainContext.class, (Injector)securityDomainContextInjector);
                }
                return () -> {
                    SecurityDomainContext domainContext = (SecurityDomainContext)securityDomainContextInjector.getValue();
                    JSSESecurityDomain jsseDomain = domainContext.getJSSE();
                    if (jsseDomain == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateJSSEConfig(legacyJSSEConfig);
                    }
                    KeyManager[] keyManagers = jsseDomain.getKeyManagers();
                    if (keyManagers == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateComponentInJSSEDomain("KeyManager", legacyJSSEConfig);
                    }
                    for (KeyManager keyManager : keyManagers) {
                        if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                        return keyManager;
                    }
                    throw SecurityLogger.ROOT_LOGGER.expectedManagerTypeNotFound("KeyManager", X509ExtendedKeyManager.class.getSimpleName(), legacyJSSEConfig);
                };
            }
        };
        return new BasicResourceDefinition("elytron-key-manager", addHandler, attributes, Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY);
    }

    public static ResourceDefinition getElytronTrustManagersResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{LEGACY_JSSE_CONFIG};
        BasicAddHandler<TrustManager> addHandler = new BasicAddHandler<TrustManager>(attributes, new RuntimeCapability[]{Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY}){

            @Override
            protected BasicService.ValueSupplier<TrustManager> getValueSupplier(ServiceBuilder<TrustManager> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String legacyJSSEConfig = ElytronIntegrationResourceDefinitions.asStringIfDefined(context, LEGACY_JSSE_CONFIG, model);
                InjectedValue securityDomainContextInjector = new InjectedValue();
                if (legacyJSSEConfig != null) {
                    serviceBuilder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{legacyJSSEConfig}), SecurityDomainContext.class, (Injector)securityDomainContextInjector);
                }
                return () -> {
                    SecurityDomainContext domainContext = (SecurityDomainContext)securityDomainContextInjector.getValue();
                    JSSESecurityDomain jsseDomain = domainContext.getJSSE();
                    if (jsseDomain == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateJSSEConfig(legacyJSSEConfig);
                    }
                    TrustManager[] trustManagers = jsseDomain.getTrustManagers();
                    if (trustManagers == null) {
                        throw SecurityLogger.ROOT_LOGGER.unableToLocateComponentInJSSEDomain("TrustManager", legacyJSSEConfig);
                    }
                    for (TrustManager trustManager : trustManagers) {
                        if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                        return trustManager;
                    }
                    throw SecurityLogger.ROOT_LOGGER.expectedManagerTypeNotFound("TrustManager", X509ExtendedTrustManager.class.getSimpleName(), legacyJSSEConfig);
                };
            }
        };
        return new BasicResourceDefinition("elytron-trust-manager", addHandler, attributes, Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY);
    }

    static String asStringIfDefined(OperationContext context, SimpleAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asString();
        }
        return null;
    }
}

