/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.json.JsonNumber;
import javax.json.JsonString;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

public class RawClaimTypeProducer {
    private static Logger log = Logger.getLogger(RawClaimTypeProducer.class);
    @Inject
    JsonWebToken currentToken;

    @Produces
    @Claim(value="")
    Set<String> getClaimAsSet(InjectionPoint ip) {
        log.debugf("getClaimAsSet(%s)", (Object)ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional value = this.currentToken.claim(name);
        return value.orElse(null);
    }

    @Produces
    @Claim(value="")
    String getClaimAsString(InjectionPoint ip) {
        log.debugf("getClaimAsString(%s)", (Object)ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        String returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonString) {
                JsonString jsonValue = (JsonString)value;
                returnValue = jsonValue.getString();
            } else {
                returnValue = value.toString();
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    Long getClaimAsLong(InjectionPoint ip) {
        log.debugf("getClaimAsLong(%s)", (Object)ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        Long returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonNumber) {
                JsonNumber jsonValue = (JsonNumber)value;
                returnValue = jsonValue.longValue();
            } else {
                returnValue = Long.parseLong(value.toString());
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    Double getClaimAsDouble(InjectionPoint ip) {
        log.debugf("getClaimAsDouble(%s)", (Object)ip);
        if (this.currentToken == null) {
            return null;
        }
        String name = RawClaimTypeProducer.getName(ip);
        Optional optValue = this.currentToken.claim(name);
        Double returnValue = null;
        if (optValue.isPresent()) {
            Object value = optValue.get();
            if (value instanceof JsonNumber) {
                JsonNumber jsonValue = (JsonNumber)value;
                returnValue = jsonValue.doubleValue();
            } else {
                returnValue = Double.parseDouble(value.toString());
            }
        }
        return returnValue;
    }

    @Produces
    @Claim(value="")
    public Optional getOptionalValue(InjectionPoint ip) {
        log.debugf("getOptionalValue(%s)", (Object)ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return this.currentToken.claim(RawClaimTypeProducer.getName(ip));
    }

    static String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

