/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.legacy;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.jms.legacy.LegacyConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.legacy.LegacyConnectionFactoryDefinition;

public class LegacyConnectionFactoryRemove
extends AbstractRemoveStepHandler {
    static final LegacyConnectionFactoryRemove INSTANCE = new LegacyConnectionFactoryRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName activeMQServerServiceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress());
        ServiceName serviceName = JMSServices.getConnectionFactoryBaseServiceName(activeMQServerServiceName).append(new String[]{"legacy", name});
        context.removeService(serviceName);
        for (String legacyEntry : LegacyConnectionFactoryDefinition.ENTRIES.unwrap((ExpressionResolver)context, model)) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)legacyEntry);
            ServiceName binderServiceName = bindInfo.getBinderServiceName();
            context.removeService(binderServiceName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        LegacyConnectionFactoryAdd.INSTANCE.performRuntime(context, operation, model);
    }
}

